// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file
/// @brief
/// @author Nobuyasu Koga

#ifndef INCLUDED_protocols_flxbb_FilterStructs_HH
#define INCLUDED_protocols_flxbb_FilterStructs_HH

#include <protocols/flxbb/FilterStructs.fwd.hh>

#include <utility/pointer/ReferenceCount.hh>
#include <core/pose/Pose.hh>

using namespace core;

namespace protocols {
namespace flxbb{


  ////////////////////////////////////////////////////////////////////////////////////////
  class FilterStructs : public utility::pointer::ReferenceCount {
  public:

    FilterStructs( pose::Pose & pose ):best_pose_( pose ), filter_on_(true){}
    virtual ~FilterStructs();

    virtual FilterStructsOP clone() const = 0;
    virtual void apply( pose::Pose & ) = 0;

    void set_bestpose( pose::Pose const & pose )
    {
      best_pose_ = pose;
    }
    void set_filter_off()
    {
      filter_on_ = false;
    }
    void set_filter_on()
    {
      filter_on_ = true;
    }

    bool filter_on() const
    {
      return filter_on_;
    }
    pose::Pose get_bestpose() const
    {
      return best_pose_;
    }

  protected:
    pose::Pose best_pose_;

  private:
    bool filter_on_;

  };

  ////////////////////////////////////////////////////////////////////////////////////////
  class FilterStructs_Packstat : public FilterStructs {
  public:

    FilterStructs_Packstat( pose::Pose & pose, Size ntrial=1 ):
			FilterStructs( pose ), ntrial_(ntrial), best_packscore_( 0.0 ){}
    virtual ~FilterStructs_Packstat();

    virtual FilterStructsOP clone() const;
    virtual void apply( pose::Pose & );

  private:
    Size ntrial_;
    core::Real best_packscore_;

  };

  ////////////////////////////////////////////////////////////////////////////////////////
  class FilterStructs_TotalCharge : public FilterStructs {
  public:

    FilterStructs_TotalCharge( pose::Pose & pose, Size ntrial=20 ): FilterStructs( pose ), ntrial_( ntrial ){}
    virtual ~FilterStructs_TotalCharge();

    virtual FilterStructsOP clone() const;
    virtual void apply( pose::Pose & );

  private:
    Size ntrial_;

  };



} // flxbb
} // protocols


#endif
