// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file
/// @brief
/// @author Nobuyasu Koga

#ifndef INCLUDED_protocols_flxbb_FlxbbDesign_HH
#define INCLUDED_protocols_flxbb_FlxbbDesign_HH

#include <protocols/flxbb/DesignLayerOperation.hh>
#include <protocols/flxbb/FilterStructs.hh>
#include <protocols/flxbb/DesignTask.hh>
#include <protocols/flxbb/BluePrint.hh>

#include <core/pose/Pose.hh>
#include <protocols/moves/Mover.hh>
#include <protocols/moves/PackRotamersMover.hh>

#include <core/scoring/ScoreFunction.hh>
#include <core/scoring/ScoreFunctionFactory.hh>
#include <core/pack/task/PackerTask.hh>

#include <core/kinematics/MoveMap.hh>

#include <utility/pointer/ReferenceCount.hh>

#include <core/options/option.hh>
#include <core/options/util.hh>

#include <core/options/keys/flxbb.OptionKeys.gen.hh>

// option key includes

using namespace core;

namespace protocols {
namespace flxbb{


	///////////////////////////////////////////////////////////////////////////////////////////////////////
	class FlxbbDesign: public moves::Mover {
	public:

		FlxbbDesign(
								core::scoring::ScoreFunctionOP const & sfxnd,
								core::scoring::ScoreFunctionOP const & sfxnr,
								BluePrintOP const & blue = 0
								):	Mover( "FlxbbDesign" ),
										nflxbb_cycle_( 3 ),
										scorefxn_relax_ ( sfxnr ),
										scorefxn_design_ ( sfxnd ),
										blueprint_ ( blue )
		{

			if( option[ OptionKeys::flxbb::ncycle ].user() ){
				nflxbb_cycle_ = option[ OptionKeys::flxbb::ncycle ]() ;
			}

		}

		virtual ~FlxbbDesign();

		virtual void apply( core::pose::Pose & pose );

		void set_blueprint( BluePrintOP const & blueprint ){
			blueprint_ = blueprint;
		}

		void set_designtask( DesignTaskOP const & design_task ){
			design_taskset_.push_back( design_task );
		}

		void set_scorefxn_design( core::scoring::ScoreFunctionOP const & scorefxn ){
			scorefxn_design_ = scorefxn;
		}

		void set_scorefxn_relax( core::scoring::ScoreFunctionOP const & scorefxn ){
			scorefxn_relax_ = scorefxn;
		}

	private:

		Size nflxbb_cycle_;
		core::scoring::ScoreFunctionOP scorefxn_relax_;
		core::scoring::ScoreFunctionOP scorefxn_design_;
		DesignTaskSet design_taskset_;
		BluePrintOP blueprint_;

	};

	///////////////////////////////////////////////////////////////////////////////////////////////////////
	class FlxbbDesignPack: public moves::PackRotamersMover {
	public:

		FlxbbDesignPack();

		FlxbbDesignPack(
										core::scoring::ScoreFunctionCOP scorefxn,
										core::pack::task::PackerTaskCOP task,
										protocols::flxbb::FilterStructsOP filter=0
										):PackRotamersMover( scorefxn, task ), filter_( filter ){}

		virtual ~FlxbbDesignPack();

		virtual void apply( core::pose::Pose & pose );

	private:
		FilterStructsOP filter_;

	};


}
}

#endif
