// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file
/// @brief
/// @author Nobuyasu Koga

// Unit Headers
#include <protocols/flxbb/FlxbbDesign_main.hh>
#include <protocols/flxbb/FlxbbDesign.hh>
#include <protocols/flxbb/BluePrint.hh>

// Project headers
#include <protocols/moves/Mover.hh>
#include <protocols/jobdist/standard_mains.hh>

#include <core/scoring/ScoreFunction.hh>
#include <core/scoring/ScoreFunctionFactory.hh>

#include <core/scoring/constraints/util.hh>
#include <core/options/option.hh>
#include <core/options/util.hh>

// option key includes
#include <core/options/keys/flxbb.OptionKeys.gen.hh>
#include <core/options/keys/in.OptionKeys.gen.hh>

using namespace core::options;
using namespace core::options::OptionKeys;

using namespace core;

namespace protocols {
namespace flxbb{

	void FlxbbDesign_main(){

		using namespace protocols::jobdist;
		using namespace protocols::moves;

		scoring::ScoreFunctionOP scorefxn = core::scoring::getScoreFunction();
		scoring::ScoreFunctionOP scorefxn_design = scorefxn;
		scoring::ScoreFunctionOP scorefxn_relax = scorefxn;

		if( option[ in::file::fullatom ]() ) {
			scoring::constraints::add_fa_constraints_from_cmdline_to_scorefxn( *scorefxn_relax );
		} else{
			scoring::constraints::add_constraints_from_cmdline_to_scorefxn( *scorefxn_relax );
		}

		MoverOP protocol;

		if( option[ OptionKeys::flxbb::blueprint ].user() ){
			BluePrintOP blueprint = new BluePrint( option[ OptionKeys::flxbb::blueprint ]().name() );
			protocol = new FlxbbDesign( scorefxn_design, scorefxn_relax, blueprint );
		}else{
			protocol = new FlxbbDesign( scorefxn_design, scorefxn_relax );
		}

		universal_main( *protocol );

	}


}
}

