// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file   protocols/jd2/DockDesignParser.hh
/// @brief  header file for Parser class, part of August 2008 job distributor
/// @author Sarel Fleishman sarelf@u.washington.edu


#ifndef INCLUDED_protocols_jd2_DockDesignParser_HH
#define INCLUDED_protocols_jd2_DockDesignParser_HH

//unit headers
#include <protocols/moves/Mover.fwd.hh>
#include <protocols/jd2/Job.fwd.hh>
#include <protocols/jd2/Parser.hh>

#include <core/pack/task/operation/TaskOperationFactory.fwd.hh>
#include <protocols/moves/MoverFactory.fwd.hh>
#include <protocols/ProteinInterfaceDesign/DockDesignFilterFactory.fwd.hh>

//project headers
#include <core/pose/Pose.fwd.hh>

//utility headers

namespace protocols {
namespace jd2 {

/// @brief Reading the xml file and generating the mover
class DockDesignParser : public Parser
{
public:
	typedef core::pack::task::operation::TaskOperationFactory TaskOperationFactory;
	typedef core::pack::task::operation::TaskOperationFactoryOP TaskOperationFactoryOP;
	typedef protocols::moves::MoverFactory MoverFactory;
	typedef protocols::moves::MoverFactoryOP MoverFactoryOP;
	typedef protocols::ProteinInterfaceDesign::DockDesignFilterFactory DockDesignFilterFactory;
	typedef protocols::ProteinInterfaceDesign::DockDesignFilterFactoryOP DockDesignFilterFactoryOP;

public:
	DockDesignParser();
	virtual ~DockDesignParser();

	virtual
	bool
	generate_mover_from_pose( JobCOP job, Pose & pose, MoverOP & mover, bool new_input );

	void register_factory_prototypes();

private:
	TaskOperationFactoryOP taskop_factory_;
	MoverFactoryOP mover_factory_;
	DockDesignFilterFactoryOP ddfilter_factory_;


}; // Parser

} // namespace jd2
} // namespace protocols

#endif //INCLUDED_protocols_jd2_DockDesignParser_HH
