// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file   protocols/jd2/DummyParser.hh
/// @brief  header file for DummyParser class, part of August 2008 job distributor
/// @author Steven Lewis smlewi@gmail.com


#ifndef INCLUDED_protocols_jd2_DummyParser_HH
#define INCLUDED_protocols_jd2_DummyParser_HH

//unit headers
#include <protocols/jd2/Parser.hh>
#include <protocols/jd2/Job.hh>
#include <protocols/moves/Mover.hh>

//project headers
#include <core/pose/Pose.hh>

//utility headers
#include <core/util/Tracer.hh>

static core::util::Tracer TR("protocols.jd2.DummyParser");

namespace protocols {
namespace jd2 {

class DummyParser : public protocols::jd2::Parser
{
public:

	virtual ~DummyParser() {}

	///@brief
	virtual
	bool
	generate_mover_from_pose( core::pose::Pose & /*pose*/, protocols::moves::MoverOP mover, bool new_input ){
		TR << "DummyParser running" << std::endl;

		//if this were a real parser, there would be logic here determining what to do
		if (!new_input) return false;

		///@brief no-op Protocol - for testing purposes
		class DummyProtocol : public protocols::moves::Mover {
		public:
			virtual ~DummyProtocol() {}

			virtual void apply( core::pose::Pose &) { TR << "Ran DummyProtocol" << std::endl; }
		};

		mover = new DummyProtocol;
		TR << "DummyParser decided to generate a new DummyProtocol" << std::endl;
		return false;
	}

}; // DummyParser

} // namespace jd2
} // namespace protocols

#endif //INCLUDED_protocols_jd2_DummyParser_HH
