// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file   protocols/jd2/SilentFileJobOutputter.hh
/// @brief  header file for SilentFileJobOutputter class, part of August 2008 job distributor as planned at RosettaCon08
/// @author Oliver Lange olange@u.washington.edu


#ifndef INCLUDED_protocols_jd2_SilentFileJobOutputter_HH
#define INCLUDED_protocols_jd2_SilentFileJobOutputter_HH

//unit headers
#include <protocols/jd2/SilentFileJobOutputter.fwd.hh>
#include <protocols/jd2/FileJobOutputter.hh>
#include <protocols/jd2/JobOutputter.hh>
#include <protocols/jd2/Job.fwd.hh>

//project headers
#include <protocols/evaluation/PoseEvaluator.hh>
#include <core/pose/Pose.fwd.hh>

//utility headers
#include <utility/file/FileName.hh>

//C++ headers
#include <string>

namespace protocols {
namespace jd2 {

///@details this is a implementation of JobOutputter for silent-file-based output.
// todo:
// read designated silent-file in beginning and implement method
// job_completed()
class SilentFileJobOutputter : public protocols::jd2::FileJobOutputter
{
public:

  typedef protocols::jd2::FileJobOutputter parent;

  SilentFileJobOutputter();

  //////////////////////////////creating output functions/////////////////////////////////////////
  ///@brief this function outputs the final result of a job.
  virtual
  void final_pose( JobCOP job, core::pose::Pose const & pose );

  ///@brief this function is intended for saving mid-protocol poses; for example the final centroid structure in a combined centroid/fullatom protocol. --->these go to file silent_filename+tag
  virtual
  void other_pose( JobCOP job, core::pose::Pose const & pose, std::string const & tag );

  /////////////////////////////////state of output functions/////////////////////////////////

  ///@brief this function is not used for output, but it belongs here since it needs to check the same output locations as the class normally writes to.  This class checks wherever output goes to see if the job's expected output already exists (on disk or whatever).  This is the most basic form of checkpointing.
  virtual
  bool job_has_completed( JobCOP job );

  ///@brief this is the master function for determining the unique output identifier for a job
  virtual
  std::string output_name( JobCOP job );

	virtual
	std::string filename( JobCOP ) const {
		return silent_file_;
	}

  //////////////////////////////////////scorefile functions/////////////////////////////////////
protected:
  //called by final_- and other_pose methods
  void dump_pose( utility::file::FileName const& filename, JobCOP job, core::pose::Pose const& pose, bool bWriteScoreOnly );

private:
  ///@brief called by the constructor to set filename and options
  void set_defaults();

	void read_done_jobs();

  // write intermediate files ( from calls to other_pose )
  bool bWriteIntermediateFiles_;

  // write also structural information to intermediate files ( from calls to other_pose )
  bool bWriteIntermediateStructures_;

  //  file name for silent-output
  utility::file::FileName silent_file_;

	utility::vector1< std::string > silent_file_tags_;
}; // SilentFileJobOutputter

} // namespace jd2
} // namespace protocols

#endif //INCLUDED_protocols_jd2_SilentFileJobOutputter_HH
