// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file   protocols/jd2/JobDistributor.cc
/// @brief  August 2008 job distributor as planned at RosettaCon08 - Base class
/// @author Oliver Lange


#include <protocols/jd2/JobDistributor.hh>
#include <protocols/jd2/JobOutputter.hh>
#include <protocols/jd2/Job.hh>

#include <core/util/Tracer.hh>

namespace protocols {
namespace jd2 {

static core::util::Tracer TR("protocols.jd2.JobDistributor");

//multithreaded case requires specia
///end parser interface, start Job Distributor interface/////////////
void output_intermediate_pose(
	core::pose::Pose const & pose,
	std::string const & stage_tag
) {
  protocols::jd2::JobDistributor* jd
  	= protocols::jd2::JobDistributor::get_instance();
  if ( jd && jd->job_outputter() && jd->current_job() ) {
    jd->job_outputter()->other_pose( jd->current_job(), pose, stage_tag );
  } else {
    TR.Warning << "can't output intermediate pose if not running with  jobdistributor ( jd2 / 2008 )" << std::endl;
  }
}

std::string current_output_name() {
	protocols::jd2::JobDistributor* jd
  	= protocols::jd2::JobDistributor::get_instance();
	if ( jd && jd->job_outputter() && jd->current_job() ) {
		return jd->job_outputter()->output_name( jd->current_job() );
	} else return "NoTag";
}

bool jd2_used() {
	protocols::jd2::JobDistributor* jd
  	= protocols::jd2::JobDistributor::get_instance();
	return ( jd && jd->job_outputter() && jd->current_job() != JD2_BOGUS_JOB );
}

} // jd2
} // protocols
