// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file   protocols/jd2/JobDistributor.cc
/// @brief  August 2008 job distributor as planned at RosettaCon08 - Base class
/// @author Andrew Leaver-Fay
/// @author Steven Lewis smlewi@gmail.com

#ifndef INCLUDED_protocols_jd2_util_HH
#define INCLUDED_protocols_jd2_util_HH

// Unit headers

// Package headers
#include <core/pose/Pose.fwd.hh>

//#include <protocols/jd2/Protocol.fwd.hh>

// Utility headers
#include <core/types.hh>

namespace protocols {
namespace jd2 {

///@brief writes pose to intermediate-scorefile using current Job and JobOutputter ..
extern void output_intermediate_pose( core::pose::Pose const& pose, std::string const& stage_tag );

///@brief gets used output name of pose
/// ask jd for current-job ---> ask jobOutputter for name of this job
extern std::string current_output_name();

///@brief is this application running with jd2 --- used for some code that yields backward compatability with old JobDistributor
extern bool jd2_used();


}
}

#endif
