// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file
/// @brief
/// @detailed
/// @author Bjorn Wallner
///


// Unit Headers
#include <protocols/jumping/MembraneJump.hh>
#include <protocols/jumping/PairingLibrary.hh>
#include <protocols/jumping/PairingLibrary.fwd.hh>

#include <protocols/jumping/PairingsList.hh>
#include <protocols/jumping/PairingsList.fwd.hh>
// Package Headers

// Project Headers
#include <core/chemical/util.hh>
#include <core/chemical/VariantType.hh>
#include <core/conformation/Conformation.hh>
#include <core/id/NamedStubID.hh>
#include <core/io/pdb/pose_io.hh>
#include <core/kinematics/Jump.hh>

#include <core/pose/Pose.hh>
#include <core/pose/util.hh>
#include <core/pose/datacache/CacheableDataType.hh>

#include <core/util/datacache/BasicDataCache.hh>

#include <core/scoring/MembraneTopology.hh>

#include <core/kinematics/FoldTree.hh>
//#include <core/kinematics/ShortestPathInFoldTree.hh>

//#include <core/fragment/FrameList.hh>
//#include <core/fragment/Frame.hh>
//#include <core/fragment/JumpingFrame.hh>
//#include <core/fragment/OrderedFragSet.hh>

//#include <core/chemical/util.hh>

// ObjexxFCL Headers
#include <ObjexxFCL/FArray1D.hh>
#include <ObjexxFCL/FArray2D.hh>
#include <ObjexxFCL/formatted.o.hh>

// Utility headers
#include <core/util/Tracer.hh>
#include <utility/io/izstream.hh>
#include <utility/vector1.hh>

//numeric headers
#include <numeric/random/random.hh>
#include <numeric/xyzVector.io.hh>
#include <numeric/xyzVector.hh>
#include <numeric/xyz.functions.hh>

//// C++ headers
#include <cstdlib>
#include <string>
#include <fstream>



namespace protocols {
namespace jumping {
using namespace core;
using namespace fragment;
static util::Tracer tr("protocols.jumping.MembraneJump");
	static numeric::random::RandomGenerator RG(750107);  // <- Magic number, do not change it!

MembraneJump::MembraneJump()
{
	template_size_=0;
	pairings_size_=0;
}

void
MembraneJump::init(std::string const& template_file,std::string const& pairings_file) {
	templates_.read_from_file_no_filters(template_file);
	read_pairing_list( pairings_file, pairings_);
	template_size_=templates_.size();
	pairings_size_=pairings_.size();

}


//this function will setup a fold tree to be used consisting of njumps using the info in templates_ and pairings_
void
MembraneJump::setup_fold_tree(core::pose::Pose & pose, core::Size njumps) const
{
	using namespace ObjexxFCL;
	using core::pose::datacache::CacheableDataType::MEMBRANE_TOPOLOGY;

	if(pairings_.size()==0)
		return;
	std::cout << "setting up fold_tree with " << njumps << " jump(s)\n";
	Size nres=pose.total_residue();
	core::kinematics::FoldTree f(nres);
	Size tries(0);
	core::scoring::MembraneTopology const & topology(*( static_cast< core::scoring::MembraneTopology const * >( pose.data().get_const_ptr( MEMBRANE_TOPOLOGY )() )));
	PairingList selected_pairings;
	FArray1D_int tmh(pose.total_residue());
	FArray1D_int tmh2(pose.total_residue(),0);
	Size total_tmhelix(topology.tmhelix());
	FArray1D_bool tmh_involved_in_jump(total_tmhelix,false);


	for ( Size j = 1; j <= pose.total_residue(); ++j ) {
		//bw change definition of membrane region to include jumps to non-tmh.
		if(j<=topology.span_end(1)) //membrane_helix(1,2))
		{
			tmh(j)=1;
		} else if(j>topology.span_end(total_tmhelix)) {
			tmh(j)=total_tmhelix;
		}
		else
		{
			for ( Size reg = 2; reg <= total_tmhelix; ++reg ) {
				if(j>topology.span_end(reg-1) && j<=topology.span_end(reg)) //membrane_helix( reg-1, 2 ) && j<=membrane_helix(reg,2))
				{
					tmh(j)=reg;
				}
			}
		}
		//		tr.Info << "RES TMH " << j << " " << res_TMH_mapping(j) << std::endl;
	}
	for ( Size i = 1; i <= pose.total_residue(); ++i ) {
		for ( Size j = 1; j <= total_tmhelix; ++j ) {
			if(i>topology.span_begin(j) && i < topology.span_end(j)) {
				tmh2(i)=j;
			}
		}
	}

//	for ( Size i = 1; i <= pose.total_residue(); ++i ) {
//		std::cout << tmh2(i);
//	}
//	std::cout << "\n";
	while(selected_pairings.size()<njumps && tries < 10) {
		Size index=static_cast< int >(RG.uniform()*pairings_.size()+1);
		std::cout << "Tries : " << tries << " " << index << ' ' << pairings_[index].pos1  << ' ' << tmh(pairings_[index].pos1) << ' ' << pairings_[index].pos2 << ' ' << tmh(pairings_[index].pos2) <<std::endl;
		bool check_compatible=true;

		//if(tmh2(pairings_[index].pos1) > 0 && tmh2(pairings_[index].pos2) > 0) //bw only one jump per tmh.
		{
			if(tmh_involved_in_jump(tmh(pairings_[index].pos1)) ||
			   tmh_involved_in_jump(tmh(pairings_[index].pos2))){
				check_compatible=false;
			}
		}
		for (Size j = 1; j <= selected_pairings.size(); ++j) {
			if(selected_pairings[j].pos1 == pairings_[index].pos1 &&
			   selected_pairings[j].pos2 == pairings_[index].pos2) // already in a jump
			{
				check_compatible=false;
			}
		}

		if(check_compatible)
		{
			selected_pairings.push_back(pairings_[index]);
			tmh_involved_in_jump(tmh(pairings_[index].pos1))=true;
			tmh_involved_in_jump(tmh(pairings_[index].pos2))=true;
		}
		++tries;
	}
	if(selected_pairings.size()<njumps)
	{
		std::cout << "WARNING: Only picked " << selected_pairings.size() << " given number was " << njumps << " only allow one jump between any two TMHs " << std::endl;
	}
	FArray2D_int jumps(2,selected_pairings.size());
	for(Size i=1;i<=selected_pairings.size();++i) {
		jumps(1,i)=selected_pairings[i].pos1;
		jumps(2,i)=selected_pairings[i].pos2;
	}
	FArray1D_float cut_bias(nres,0.0);
	for ( Size i = 1; i <= pose.total_residue(); ++i ) {
		if(tmh2(i)==0) {
			cut_bias(i)=1;
		}
	}

	int num_jumps_in=selected_pairings.size();
	f.random_tree_from_jump_points(nres,num_jumps_in,jumps,cut_bias);
	f.put_jump_stubs_intra_residue();


//	f.new_jump(16,209,150);
	std::cout <<  f;
	pose.fold_tree(f);
//	std::cout <<  pose.fold_tree() << "\n";
	//add copy in jump templates
/*
	for(Size i=1;i<=pose.total_residue();++i) {
				pose.set_phi(i,-60);
				pose.set_psi(i,-40);
				}	*/

				/*
	Size const MAX_POS( 5 ); // param::MAX_POS
	FArray2D_float Epos1(3,MAX_POS), Epos2(3,MAX_POS);
Epos1(1,1)=23.840; Epos1(2,1)=   50.029; Epos1(3,1)= 12.421;
Epos1(1,2)=24.990; Epos1(2,2)=   49.472; Epos1(3,2)= 13.132;
Epos1(1,4)=24.590; Epos1(2,4)=   49.015; Epos1(3,4)= 14.533;
Epos1(1,3)=25.041; Epos1(2,3)=   47.962; Epos1(3,3)= 15.001;


Epos2(1,1)=27.660; Epos2(2,1)= 49.494  ; Epos2(3,1)= 6.131;
Epos2(1,2)=26.619; Epos2(2,2)= 48.609  ; Epos2(3,2)= 6.643;
Epos2(1,4)=26.693; Epos2(2,4)= 47.250  ; Epos2(3,4)= 5.965;
Epos2(1,3)=26.600; Epos2(2,3)= 46.217  ; Epos2(3,3)= 6.626;

	pose::Pose pose_tmp;
	io::pdb::pose_from_pdb( pose_tmp, "BRD7.pdb");
	pose_tmp.fold_tree(f);
	*/
  	for(Size i=1;i<=selected_pairings.size();++i) {
			//		int jump_number=i;
		Size p1=selected_pairings[i].pos1;
		Size p2=selected_pairings[i].pos2;

		//pose.set_phi(p1,
		/*
		for ( int j = 1; j <= 2; ++j ) {
			const int pos (jumps(j,jump_number) );
		//	pose.set_allow_bb_move( pos, true );
			pose.set_phi  ( pos, t.phi(j) );
			pose.set_psi  ( pos, t.psi(j) );
			pose.set_omega( pos, t.omega(j) );
			//if(pose.membrane()) {
			//pose.set_secstruct( pos, 'H' );
			//  } else {
		//	pose.set_secstruct( pos, 'E' );
			// }
		//	pose.set_allow_bb_move( pos, false ); // DANGER!!!!!!!!!!!!!!!!!!!
		}
		 */

		// core::kinematics::Jump rt(templates_.get_random_tmh_jump(selected_pairings[i].orientation,p1,p2));
		// pose.set_jump(jump_number,rt);

		core::kinematics::RT rt(templates_.get_random_tmh_jump(selected_pairings[i].orientation,p1,p2));
		id::StubID up_stub,down_stub;
		up_stub = core::id::StubID( core::id::NamedStubID( "CA","N","CA","C", p1 ), pose );
		down_stub = core::id::StubID( core::id::NamedStubID( "CA","N","CA","C", p2 ), pose );
		pose.conformation().set_stub_transform( up_stub, down_stub, rt );
		core::chemical::add_variant_type_to_pose_residue( pose, chemical::CUTPOINT_LOWER, f.cutpoint(i) );
		core::chemical::add_variant_type_to_pose_residue( pose, chemical::CUTPOINT_UPPER, f.cutpoint(i)+1 );



//		pose_tmp.conformation().set_stub_transform( up_stub, down_stub, rt );


//		  core::kinematics::Jump RT(RT_from_epos(Epos1,Epos2));


		 //core::kinematics::Jump RT_reverse(RT);
		//RT_reverse.reverse();
	//	 std::cout << "SET JUMP " << jump_number << " " <<  RT << "\n";
		//std::cout << "SET JUMP " << RT_reverse << "\n";


		//pose.set_jump( jump_number, RT) ;//core::kinematics::Jump(templates_.get_random_tmh_jump(selected_pairings[i].orientation,selected_pairings[i].pos1,selected_pairings[i].pos2)));
		//pose_tmp.set_jump( jump_number, RT) ;//core::kinematics::Jump(templates_.get_random_tmh_jump(selected_pairings[i].orientation,selected_pairings[i].pos1,selected_pairings[i].pos2)));
//		templates_.set_tmh_jump(pose,jump_number,selected_pairings[i].orientation,selected_pairings[i].pos1,selected_pairings[i].pos2);
		//std::cout << pose.atom_tree().atom( jump_atom_id( jump_number ) ).get_input_stub() << "\n";
		//std::cout << pose.atom_tree().atom( jump_atom_id( jump_number ) ).get_stub() << "\n";
	}

	/*
	Vector const & n1( pose.residue( 16 ).atom( "N" ).xyz());
	Vector const & ca1( pose.residue( 16 ).atom( "CA" ).xyz());
	Vector const & c1( pose.residue( 16 ).atom( "C" ).xyz());
	Vector const & o1( pose.residue( 16 ).atom( "O" ).xyz());

	Vector const  & n2( pose.residue( 209 ).atom( "N" ).xyz());
	Vector const & ca2( pose.residue( 209 ).atom( "CA" ).xyz());
	Vector const & c2( pose.residue( 209 ).atom( "C" ).xyz());
	Vector const & o2( pose.residue( 209 ).atom( "O" ).xyz());

	Vector const & tmp_n1( pose_tmp.residue( 16 ).atom( "N" ).xyz());
	Vector const & tmp_ca1( pose_tmp.residue( 16 ).atom( "CA" ).xyz());
	Vector const & tmp_c1( pose_tmp.residue( 16 ).atom( "C" ).xyz());
	Vector const & tmp_o1( pose_tmp.residue( 16 ).atom( "O" ).xyz());

	Vector const  & tmp_n2( pose_tmp.residue( 209 ).atom( "N" ).xyz());
	Vector const & tmp_ca2( pose_tmp.residue( 209 ).atom( "CA" ).xyz());
	Vector const & tmp_c2( pose_tmp.residue( 209 ).atom( "C" ).xyz());
	Vector const & tmp_o2( pose_tmp.residue( 209 ).atom( "O" ).xyz());


	Real dist_ca,dist_c,dist_n,dist_o;

	dist_ca=(ca1-ca2).length();
	dist_c=(c1-c2).length();
	dist_n=(n1-n2).length();
	dist_o=(o1-o2).length();

	std::cout << "CA1 "<< ca1 << "\n";
	std::cout << "CA2 " << ca2 << "\n";

	std::cout << "CA-CA " << dist_ca << std::endl;
	std::cout << "N-N " << dist_n << std::endl;
	std::cout << "C-C " << dist_c << std::endl;
	std::cout << "O-O " << dist_o << std::endl;


	Real ndist_ca,ndist_c,ndist_n,ndist_o;

	ndist_ca=(tmp_ca1-tmp_ca2).length();
	ndist_c=(tmp_c1-tmp_c2).length();
	ndist_n=(tmp_n1-tmp_n2).length();
	ndist_o=(tmp_o1-tmp_o2).length();

	std::cout << "N CA1 "<< tmp_ca1 << "\n";
	std::cout << "N CA2 " << tmp_ca2 << "\n";

	std::cout << "N CA-CA " << ndist_ca << std::endl;
	std::cout << "N N-N " << ndist_n << std::endl;
	std::cout << "N C-C " << ndist_c << std::endl;
	std::cout << "N O-O " << ndist_o << std::endl;


	Real diff_ca,diff_c,diff_n,diff_o;
	diff_ca=std::abs(dist_ca-ndist_ca);
	diff_c=std::abs(dist_c-ndist_c);
	diff_n=std::abs(dist_n-ndist_n);
	diff_o=std::abs(dist_o-ndist_n);
	std::cout << "DIFF CA-CA " << diff_ca << std::endl;
	std::cout << "DIFF N-N " << diff_n << std::endl;
	std::cout << "DIFF C-C " << diff_c << std::endl;
	std::cout << "DIFF O-O " << diff_o << std::endl;
	//std::cout << pose.atom_tree() << "\n";
	*/
	//pose.dump_pdb("pose_after_fold_tree_creations.pdb");
	//pose_tmp.dump_pdb("pose_after_fold_tree_creations.native.pdb");
	//std::exit(1);

}

} //jumping
} //protocols
