// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file   protocols/ligand_docking/LigandDockProtocol.hh
///
/// @brief
/// @author Gordon Lemmon


#ifndef INCLUDED_protocols_ligand_docking_MultiResidueLigandDock_HH
#define INCLUDED_protocols_ligand_docking_MultiResidueLigandDock_HH

#include <protocols/ligand_docking/MultiResidueLigandDock.fwd.hh>
#include <protocols/ligand_docking/ligand_scores.hh>
#include <protocols/jd2/Job.hh>
#include <core/scoring/ScoreFunction.fwd.hh>

#include <core/kinematics/MoveMap.fwd.hh>
#include <core/pose/Pose.fwd.hh>
#include <protocols/moves/Mover.hh>
#include <protocols/ligand_docking/ligand_options/LigandOptionMap.hh>

#include <map>

namespace protocols {
namespace ligand_docking {

static core::util::Tracer multi_residue_ligand_dock_tracer("protocols.ligand_docking.MultiResidueLigandDock", core::util::t_debug);

///@brief
///
///@details
///
class MultiResidueLigandDock : public protocols::moves::Mover{

public:

	MultiResidueLigandDock();
	virtual ~MultiResidueLigandDock();

	virtual void apply( core::pose::Pose & pose );

private:
	ligand_options::LigandOptionMap command_map_;

	MultiResidueLigandDock(MultiResidueLigandDock const & that);

	void
	add_scores_to_job(
		core::pose::Pose & pose
	);

	/// @brief For multiple ligands, append ligand docking scores for each ligand
	void
	append_ligand_docking_scores(
			core::pose::Pose const & before,
			core::pose::Pose const & after) const;

	/// @brief Scores to be output that aren't normal scorefunction terms.
	void
	append_ligand_docking_scores(
		int const jump_id,
		protocols::jd2::JobOP job,
		core::pose::Pose const & before,
		core::pose::Pose const & after
	) const;

}; // class MultiResidueLigandDock


} // namespace ligand_docking
} // namespace protocols

#endif // INCLUDED_protocols_ligand_docking_MultiResidueLigandDock_HH
