// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file   core/pack/task/ResfileReader.hh
/// @brief  header of classes for resfile options
/// @author Gordon Lemmon

// Unit Headers
#include <protocols/ligand_docking/ligand_options/BaseOptions.hh>

// Project headers
#include <core/conformation/Residue.hh>
#include <core/kinematics/FoldTree.hh>

namespace protocols {
namespace ligand_docking {
namespace ligand_options {


///////////////////////////////////////////////////////////////////////
///@brief base and middle tier classes.

utility::vector1< core::Size >
DefaultCommand::get_ligand_jump_ids()const{
	if ( pose_.num_jump()== 0 ) {
		utility_exit_with_message("Pose has no jumps!");
	}

	utility::vector1< core::Size > ligand_jump_ids;
	for(core::Size jump_id=1; jump_id<= (core::Size) pose_.num_jump(); jump_id++){

		core::Size const ligand_id = (core::Size) pose_.fold_tree().downstream_jump_residue(jump_id);
		core::conformation::Residue const &  residue= pose_.residue(ligand_id);

		if(residue.is_ligand()){
			ligand_jump_ids.push_back(jump_id);
		}
	}
	return ligand_jump_ids;
}

std::set<core::Size>
DefaultCommand::get_ligand_chain_ids()const{
	utility::vector1< core::Size > ligand_jump_ids= get_ligand_jump_ids();
	std::set<core::Size> chains;
	for(utility::vector1<core::Size>::iterator index(ligand_jump_ids.begin()), end(ligand_jump_ids.end());
			index != end; ++index){
		core::Size downstream_residue_id = (core::Size) pose_.fold_tree().downstream_jump_residue(*index);
		core::conformation::Residue const & residue = pose_.residue(downstream_residue_id);
		chains.insert(residue.chain());
	}
	return chains;
}

} //namespace ligand_options
} //namespace ligand_docking
} //namespace protocols

