// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file   core/pack/task/ResfileReader.hh
/// @brief  header of classes for resfile options
/// @author Gordon Lemmon

#ifndef INCLUDED_protocols_ligand_docking_ligand_options_BaseOptions_FWD_HH
#define INCLUDED_protocols_ligand_docking_ligand_options_BaseOptions_FWD_HH

// Unit Headers

//Utility Headers
#include <utility/pointer/owning_ptr.hh>

namespace protocols {
namespace ligand_docking{
namespace ligand_options{

class LigandOptionCommand;

enum Distribution{
	uniform,
	gaussian
};

typedef utility::pointer::owning_ptr< LigandOptionCommand > LigandOptionCommandOP;
typedef utility::pointer::owning_ptr< LigandOptionCommand const > LigandOptionCommandCOP;

} //namespace ligand_options
} //namespace ligand_docking
} //namespace protocols

#endif
