// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file   core/pack/task/ResfileReader.hh
/// @brief  header of classes for resfile options
/// @author Gordon Lemmon

#ifndef INCLUDED_protocols_ligand_docking_ligand_options_BaseOptions_HH
#define INCLUDED_protocols_ligand_docking_ligand_options_BaseOptions_HH

// Unit Headers
#include <protocols/ligand_docking/ligand_options/chain_functions.hh>
#include <protocols/ligand_docking/ligand_options/BaseOptions.fwd.hh>
#include <protocols/ligand_docking/ligand_options/LigandOptionMap.fwd.hh>

// Package Headers
#include <core/pose/Pose.hh>

//Utility Headers
#include <utility/vector1.hh>
#include <utility/pointer/ReferenceCount.hh>
#include <core/util/Tracer.hh>

// STL Headers
#include <set>

namespace protocols {
namespace ligand_docking {
namespace ligand_options {

static core::util::Tracer base_option_tracer("protocols.ligand_docking.ligand_options.BaseOptions", core::util::t_debug);

///@brief abstract/interface class for Resfile reader command objects
class LigandOptionCommand : public utility::pointer::ReferenceCount
{
public:
	LigandOptionCommand(core::pose::Pose & pose): pose_(pose){}

	virtual
	void option(
			utility::vector1< std::string > const & /*tokens*/,
			std::set<core::Size> const & /* ligands_to_dock */
	){yell();}

	virtual
	void option(
			utility::vector1< std::string > const & /*tokens*/,
			core::Size const & /*chain*/
	) {yell();}

	ligand_options::option type() const {
		yell();
		return soft_rep;
	}

	virtual void apply(){};

protected:
	core::pose::Pose & pose_;

	void yell() const{
		core::util::Error() << "Parent of this function shouldn't be called" << std::endl;
		utility_exit();
	}
};

///@brief abstract/interface class for Resfile reader command objects
class DefaultCommand : virtual public LigandOptionCommand
{
public:
	DefaultCommand(core::pose::Pose & pose):LigandOptionCommand(pose){}
	///@brief residue_action is the activity code for the option
	virtual
	void option(
		utility::vector1< std::string > const & /*tokens*/,
		std::set<core::Size> const & /*ligands_to_dock*/
	) = 0;

//	virtual void apply();

	virtual ligand_options::option type() const=0;

protected:
	utility::vector1< core::Size >
	get_ligand_jump_ids()const;

	std::set<core::Size>
	get_ligand_chain_ids()const;

};//class DefaultCommand

///@brief abstract/interface class for Resfile reader command objects
class LigandSpecificCommand : virtual public LigandOptionCommand
{
public:
	///@brief option is the activity code for the option
	LigandSpecificCommand( core::pose::Pose & pose): LigandOptionCommand(pose){}

	virtual
	void option(
		utility::vector1< std::string > const & /*tokens*/,
		core::Size const & /*ligand*/
	) = 0;

//	virtual void apply();

	virtual ligand_options::option type() const=0;


private:
//	LigandSpecificCommand(){yell();}

};// class LigandSpecificCommand

class InitialMoverOption : virtual public DefaultCommand, virtual public LigandSpecificCommand{
	///@brief map for the translate and rotate options
public:
	InitialMoverOption( core::pose::Pose & pose):
			LigandOptionCommand(pose),
			DefaultCommand(pose),
			LigandSpecificCommand(pose)
	{
		distribution_map_["uniform"]=uniform;
		distribution_map_["gaussian"]=gaussian;
	}
protected:
	std::map< std::string, Distribution > distribution_map_;
};




} //namespace ligand_options
} //namespace ligand_docking
} //namespace protocols

#endif

