// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file   protocols/ligand_docking/ligand_options/LigandOptionReader.fwd.hh
/// @brief  fwd header of classes for Ligand Options
/// @author

#ifndef INCLUDED_protocols_ligand_docking_ligand_options_LigandOptionMap_FWD_HH
#define INCLUDED_protocols_ligand_docking_ligand_options_LigandOptionMap_FWD_HH

//Utility Headers
#include <utility/pointer/owning_ptr.hh>

namespace protocols {
namespace ligand_docking{
namespace ligand_options{

class LigandOptionMap;

enum option{
	protocol,
	soft_rep,
	random_conformer,
	translate,
	rotate,
	improve_orientation,
	min_rms,
	max_poses,
	mutate_same_name3,
	minimize_ligand,
	minimize_backbone,
	tether_ligand,
	start_from,
	slide_together
};


typedef utility::pointer::owning_ptr< LigandOptionMap > LigandOptionMapOP;
typedef utility::pointer::owning_ptr< LigandOptionMap const > LigandOptionMapCOP;
//typedef utility::pointer::access_ptr< LigandOptionMap > LigandOptionMapAP;

} //namespace ligand_options
} //namespace ligand_docking
} //namespace protocols






#endif
