// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file   core/pack/task/ResfileReader.hh
/// @brief  header of classes for resfile options
/// @author Steven Lewis
/// @author Andrew Leaver-Fay

#ifndef INCLUDED_protocols_ligand_docking_ligand_options_LigandOptionMap_HH
#define INCLUDED_protocols_ligand_docking_ligand_options_LigandOptionMap_HH

// Unit Headers
#include <protocols/ligand_docking/ligand_options/LigandOptionMap.fwd.hh>
#include <protocols/ligand_docking/ligand_options/BaseOptions.hh>
#include <protocols/ligand_docking/ligand_options/ProtocolOption.hh>

// Package Headers
#include <core/pose/Pose.hh>
#include <core/kinematics/MoveMap.hh>
#include <protocols/moves/Mover.hh>
#include <protocols/moves/MinMover.hh>

// Project Headers
#include <core/types.hh>

// Utility Headers
#include <utility/vector1.hh>
#include <utility/pointer/ReferenceCount.hh>
#include <utility/exit.hh>
#include <core/util/Tracer.hh>

// STL Headers
#include <iosfwd>
#include <map>
#include <string>

namespace protocols {
namespace ligand_docking {
namespace ligand_options {

static core::util::Tracer option_map_tracer("protocols.ligand_docking.ligand_options.OptionMap", core::util::t_debug);

class LigandOptionMap: public std::map<option, LigandOptionCommandOP>{
	///@brief utility function for resfile reader
public:
	LigandOptionMap();
	LigandOptionMap(core::pose::Pose & pose);
	LigandOptionMap(core::pose::Pose & pose, std::string const & options_file_string );

	void release_constraints();

	void parse_default_ligand_option_file(core::pose::Pose & pose);

	///@brief this getter resets the score_fxn, so not const
	protocols::moves::MinMoverOP const
	get_final_min_mover();

	core::scoring::ScoreFunctionOP const &
	get_score_function()const;

	std::set<core::Size> const get_docking_ligands(core::pose::Pose const & pose) const;

private:
	utility::vector1< std::string >
	tokenize_line( std::istream & inputstream );

	///@brief utility for resfile reader, commands MUST be entered into this hard-coded map
	void add_commands(core::pose::Pose & pose);

	///@brief utility function for LigandOption reader (removes # comments from a list of tokens)
	void remove_comments( utility::vector1< std::string > & tokens);

	///@brief
	void parse_ligand_option_file( core::pose::Pose & pose, std::string const filename );

	void parse_options_file_string( core::pose::Pose & pose, std::string const & options_file_string );

	void populate_option_map();

	core::scoring::ScoreFunctionOP const & get_final_score_fxn();

	core::kinematics::MoveMapOP const get_final_move_map() const;

	std::map<std::string, option> option_map_;
	std::set<core::Size> ligands_to_dock_;
};


}//namespace ligand_options
}//namespace ligand_docking
}//namespace protocols

#endif
