// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file   core/pack/task/ResfileReader.hh
/// @brief  header of classes for resfile options
/// @author Gordon Lemmon

#ifndef INCLUDED_protocols_ligand_docking_ligand_options_Minimize_backbone_HH
#define INCLUDED_protocols_ligand_docking_ligand_options_Minimize_backbone_HH

// Unit Headers
#include <protocols/ligand_docking/ligand_options/BaseOptions.hh>
#include <protocols/ligand_docking/ligand_options/LigandOptionMap.fwd.hh>
#include <protocols/ligand_docking/ligand_options/Interface.hh>

// Package Headers
//#include <core/pose/Pose.hh>
#include <core/kinematics/FoldTree.hh> // REWORK THIS HEADER SO THAT THIS INCLUDE IS UNNECESSARY
#include <protocols/loops/LoopClass.hh>

//// Project Headers
//#include <core/types.hh>
//#include <core/grid/CartGrid.hh>
//
//// Utility Headers
//#include <utility/vector1.hh>
//#include <utility/exit.hh>
#include <core/util/Tracer.hh>
//
//// STL Headers


///////////////////////////////////////////////////////////////////////

namespace protocols {
namespace ligand_docking {
namespace ligand_options {

static core::util::Tracer minimize_backbone_tracer("protocols.ligand_docking.ligand_options.Minimize_backbone", core::util::t_debug);

///@brief
class Minimize_backbone : public LigandSpecificCommand, public DefaultCommand
{
public:
	Minimize_backbone(core::pose::Pose & pose);

	void option(
		utility::vector1< std::string > const & tokens,
		core::Size const & ligand
	);

	void option(
		utility::vector1< std::string > const & tokens,
		std::set<core::Size> const & ligands_to_dock
	);

	void apply();

	ligand_options::option type()const {return minimize_backbone;}

	const std::map<core::Size, core::Real> &
	get_const_ligands_reference();

private:
	std::map<core::Size, core::Real> chains_;

	void setup_bbmin_foldtree();

	void reorder_foldtree_around_mobile_regions(Interface const & interface);

	void reorder_with_first_non_mobile_as_root(
			core::kinematics::FoldTree & f,
			const Interface & interface
	);

	core::kinematics::FoldTreeOP
	create_fold_tree_with_ligand_jumps_from_attach_pts(const core::kinematics::FoldTree &, const Interface & interface);

	core::kinematics::FoldTreeOP
	create_fold_tree_with_cutpoints(const core::kinematics::FoldTree & f, const Interface & interface);

	utility::vector1< protocols::loops::Loop >
	add_cut_points(
			const core::kinematics::Edge & edge,
			const Interface & interface
	);

	std::map<core::Size, core::Size> find_attach_pts(const Interface interface) const;

	core::Size find_attach_pt(const core::Size jump_id, const Interface interface)const;

	core::Size
	find_peptide_attach_pt(
		const core::kinematics::FoldTree::const_iterator e,
		const std::map<core::Size, core::Size >jump_to_attach
	) const;

	void restrain_protein_Calphas(Interface const & interface);

	void restrict_to_protein_residues(Interface & interface) const;

};


} //namespace ligand_options
} //namespace ligand_docking
} //namespace protocols

#endif
