// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file   core/pack/task/ResfileReader.hh
/// @brief  header of classes for resfile options
/// @author Gordon Lemmon

#ifndef INCLUDED_protocols_ligand_docking_ligand_options_Minimize_ligand_HH
#define INCLUDED_protocols_ligand_docking_ligand_options_Minimize_ligand_HH

// Unit Headers
#include <protocols/ligand_docking/ligand_options/BaseOptions.hh>
#include <protocols/ligand_docking/ligand_options/LigandOptionMap.fwd.hh>

// Package Headers
//#include <core/pose/Pose.hh>
//#include <protocols/loops/LoopClass.hh>
#include <protocols/ligand_docking/ResidueTorsionRestraints.hh>
//#include <protocols/moves/Mover.hh>
//#include <core/kinematics/MoveMap.hh>
//#include <core/pack/task/PackerTask.hh>
//
//// Project Headers
//#include <core/types.hh>
//#include <core/grid/CartGrid.hh>
//
//// Utility Headers
//#include <utility/vector1.hh>
//#include <utility/exit.hh>
//#include <core/util/Tracer.hh>
//
//
//// STL Headers
//#include <iosfwd>
//#include <map>
//#include <string>
//#include <set>

///////////////////////////////////////////////////////////////////////

namespace protocols {
namespace ligand_docking {
namespace ligand_options {

static core::util::Tracer minimize_ligand_tracer("protocols.ligand_docking.ligand_options.Minimize_ligand", core::util::t_debug);

///@brief
class Minimize_ligand : public LigandSpecificCommand, public DefaultCommand
{
public:
	Minimize_ligand(core::pose::Pose & pose);

	void option(
		utility::vector1< std::string > const & tokens,
		core::Size const & ligand
	);

	void option(
		utility::vector1< std::string > const & tokens,
		std::set<core::Size> const & ligands_to_dock
	);

	void apply();
	ligand_options::option type()const {return minimize_ligand;}

	const std::set< protocols::ligand_docking::ResidueTorsionRestraintsOP > &
	get_const_ligand_torsion_restraints_reference() const;

	const std::map<core::Size, core::Real> &
	get_const_ligands_reference();

private:
	bool applied_;
	// this is a map<chain_id, stdev in degrees>.  replaces "harmonic torsions"
	std::map<core::Size, core::Real> chains_;

	std::set< protocols::ligand_docking::ResidueTorsionRestraintsOP > ligand_torsion_restraints_;
};


} //namespace ligand_options
} //namespace ligand_docking
} //namespace protocols

#endif
