// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file   core/pack/task/ResfileReader.cc
/// @brief  implementation of resfile reader and its command classes
/// @author Gordon Lemmon (glemmon@gmail.com), adapted from the ResfileReader code
/// by Steven Lewis (smlewi@unc.edu) and Andrew Leaver-Fay

// Unit Headers
#include <protocols/ligand_docking/ligand_options/Mutate_same_name3.hh>
//#include <protocols/ligand_docking/grid_functions.hh>
#include <protocols/ligand_docking/RandomConformerMover.hh>
#include <protocols/ligand_docking/UnconstrainedTorsionsMover.hh>
//#include <protocols/ligand_docking/ResidueTorsionRestraints.hh>
#include <protocols/ligand_docking/ligand_options/InterfaceBuilder.hh>

#include <protocols/geometry/RB_geometry.hh>
#include <protocols/moves/RigidBodyMover.hh>
#include <protocols/moves/Mover.hh>
#include <protocols/docking/DockingInitialPerturbation.hh>

#include <core/scoring/constraints/HarmonicFunc.hh>
#include <core/scoring/constraints/CoordinateConstraint.hh>
//#include <core/scoring/rms_util.hh>
#include <core/id/AtomID.hh>

// Package Headers
#include <core/pose/Pose.hh>
#include <core/io/database/open.hh>

// Project Headers
#include <core/chemical/ResidueType.hh>
#include <core/options/option.hh>
#include <core/options/keys/OptionKeys.hh>
#include <core/scoring/methods/EnergyMethodOptions.hh>
#include <core/kinematics/Edge.hh>
//#include <core/chemical/util.hh>

// Utility Headers
#include <utility/io/izstream.hh>
#include <utility/exit.hh>
#include <utility/assert.hh> //ASSERT_ONLY makes release build happy
#include <utility/string_util.hh>
#include <core/util/Tracer.hh>
#include <core/types.hh>
//#include <numeric/random/random.hh>

using core::util::T;
using core::util::Error;
using core::util::Warning;

//STL headers
#include <string>
//#include <iostream> //need this for debugging
#include <fstream>
#include <sstream> //automatic checking string to int conversion
#include <cctype> //for split_lines to handle '\t' tab characters
#include <stdlib.h>
#include <set>

namespace protocols {
namespace ligand_docking {
namespace ligand_options {

///@brief
Mutate_same_name3::Mutate_same_name3(core::pose::Pose & pose) :
	LigandOptionCommand(pose), LigandSpecificCommand(pose),
			DefaultCommand(pose) {
}

void Mutate_same_name3::option(
		utility::vector1< std::string> const & /*tokens*/,
		core::Size const & ligand
) {
	chains_.insert(ligand);
}

void Mutate_same_name3::option(
		utility::vector1< std::string> const & /*tokens*/,
		std::set<core::Size> const & ligands_to_dock
){
	chains_= ligands_to_dock;
}

const std::set<core::Size> &
Mutate_same_name3::get_const_ligands_to_mutate_reference() const {
	return chains_;
}

} //namespace ligand_options
} //namespace ligand_docking
} //namespace protocols
