// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file   core/pack/task/ResfileReader.hh
/// @brief  header of classes for resfile options
/// @author Gordon Lemmon

#ifndef INCLUDED_protocols_ligand_docking_ligand_options_Mutate_same_name3_HH
#define INCLUDED_protocols_ligand_docking_ligand_options_Mutate_same_name3_HH

// Unit Headers
#include <protocols/ligand_docking/ligand_options/BaseOptions.hh>
//#include <protocols/ligand_docking/ligand_options/LigandOptionMap.fwd.hh>
//#include <protocols/ligand_docking/ligand_options/InterfaceBuilder.hh>

// Package Headers
//#include <core/pose/Pose.hh>
//#include <protocols/ligand_docking/ResidueTorsionRestraints.hh>
//#include <protocols/loops/LoopClass.hh>

// Project Headers
//#include <core/types.hh>
//#include <core/grid/CartGrid.hh>
//#include <core/kinematics/FoldTree.hh>

// Utility Headers
#include <utility/vector1.hh>
#include <utility/exit.hh>
#include <core/util/Tracer.hh>


// STL Headers
//#include <iosfwd>
//#include <map>
//#include <string>
//#include <set>

///////////////////////////////////////////////////////////////////////

namespace protocols {
namespace ligand_docking {
namespace ligand_options {



///@brief
class Mutate_same_name3 : public LigandSpecificCommand, DefaultCommand
{
public:
	Mutate_same_name3(core::pose::Pose & pose);

	void option(
		utility::vector1< std::string > const & tokens,
		core::Size const & ligand
	);

	void option(
			utility::vector1< std::string > const & tokens,
			std::set<core::Size> const & ligands_to_dock
	);

	std::set<core::Size> const & get_const_ligands_to_mutate_reference() const;

	ligand_options::option type()const {return mutate_same_name3;}

private:
	std::set<core::Size>chains_;
};

} //namespace ligand_options
} //namespace ligand_docking
} //namespace protocols

#endif
