// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file   core/pack/task/ResfileReader.hh
/// @brief  header of classes for resfile options
/// @author Gordon Lemmon

#ifndef INCLUDED_protocols_ligand_docking_ligand_options_ProtocolOption_HH
#define INCLUDED_protocols_ligand_docking_ligand_options_ProtocolOption_HH

// Unit Headers
#include <protocols/ligand_docking/ligand_options/BaseOptions.hh>
#include <protocols/ligand_docking/ligand_options/LigandOptionMap.fwd.hh>
#include <protocols/ligand_docking/ligand_options/Interface.hh>

// Package Headers
#include <core/pose/Pose.hh>
#include <protocols/ligand_docking/ResidueTorsionRestraints.hh>
#include <protocols/moves/Mover.hh>
#include <core/kinematics/MoveMap.hh>
#include <core/pack/task/PackerTask.hh>

// Project Headers
#include <core/types.hh>

// Utility Headers
#include <utility/vector1.hh>
#include <core/util/Tracer.hh>


// STL Headers
#include <map>
#include <string>
#include <set>

///////////////////////////////////////////////////////////////////////

namespace protocols {
namespace ligand_docking {
namespace ligand_options {

static core::util::Tracer protocol_tracer("protocols.ligand_docking.ligand_options.Protocol", core::util::t_debug);

class Protocol: public DefaultCommand
{
public:
	enum protocol_enum {
		meiler2006,
		abbreviated,
		abbrev2,
		min_only,
		custom
	};

	Protocol(
		core::pose::Pose & pose,
		core::scoring::ScoreFunctionOP const & score_fxn,
		std::map<core::Size, core::Real> const & ligand_chains_to_minimize,
		std::set< protocols::ligand_docking::ResidueTorsionRestraintsOP > const ligand_torsion_restraints,
		std::map<core::Size, core::Real> const & ligands_around_which_to_minimize_bb,
		std::set<core::Size> const & ligands_with_rotamers
	);

	void option(
		utility::vector1< std::string > const & tokens,
		std::set<core::Size> const & ligands_to_dock
	);

	ligand_options::option type() const {return protocol;}

	core::kinematics::MoveMapOP
	make_movemap(
		bool const minimize_bb= false,
		bool const minimize_water=true
	)const;

//	const std::set<core::Size> get_docking_jump_ids() const;

	void apply();

private:
	core::Size num_cycles_;
	core::Size repack_every_Nth_;
	std::map< std::string, protocol_enum > enum_map_;

	void set_cycles(protocol_enum const p, std::string const num_cycles="", std::string const repack_every_Nth="");

	void enable_ligand_rotamer_packing(
		core::Size const ligand_residue_id,
		core::pack::task::PackerTaskOP & pack_task
	) const;

	core::pack::task::PackerTaskOP make_packer_task(bool all_residues= false) const;

	core::pack::task::PackerTaskOP make_packer_task_from_vector(Interface const allow_repack) const;

	void
	remove_ligands_to_not_minimize(
			Interface & interface
	) const;

	utility::vector1<protocols::moves::MoverOP> create_rigid_body_movers() const;
	void apply_rigid_body_moves(utility::vector1<protocols::moves::MoverOP> & rigid_body_movers);

	void set_all_chi(core::kinematics::MoveMapOP movemap)const;
	void set_all_bb(core::kinematics::MoveMapOP movemap)const;

	// References
	core::pose::Pose & pose_;
	std::set<core::Size> ligands_to_dock_;
	core::scoring::ScoreFunctionOP const & score_fxn_;
	std::map<core::Size, core::Real> const & ligand_chains_to_minimize_;
	std::set< protocols::ligand_docking::ResidueTorsionRestraintsOP > const ligand_torsion_restraints_;
	std::map<core::Size, core::Real> const & ligands_around_which_to_minimize_bb_;
	std::set<core::Size> const & ligands_with_rotamers_;
};

} //namespace ligand_options
} //namespace ligand_docking
} //namespace protocols

#endif
