// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file   core/pack/task/ResfileReader.hh
/// @brief  header of classes for resfile options
/// @author Gordon Lemmon

#ifndef INCLUDED_protocols_ligand_docking_ligand_options_Random_conformer_HH
#define INCLUDED_protocols_ligand_docking_ligand_options_Random_conformer_HH

// Unit Headers
#include <protocols/ligand_docking/ligand_options/BaseOptions.hh>
#include <protocols/ligand_docking/ligand_options/LigandOptionMap.fwd.hh>


// Package Headers

#include <protocols/ligand_docking/ResidueTorsionRestraints.hh>

///////////////////////////////////////////////////////////////////////

namespace protocols {
namespace ligand_docking {
namespace ligand_options {


class Random_conformer : public LigandSpecificCommand, public DefaultCommand
{
public:
	Random_conformer(
		core::pose::Pose & pose,
		std::set< protocols::ligand_docking::ResidueTorsionRestraintsOP > const & restraints
	);

	void
	option(
		utility::vector1< std::string > const & tokens,
		std::set<core::Size> const & ligands_to_dock
	);

	void
	option(
		utility::vector1< std::string > const & /*tokens*/,
		core::Size const & ligand_chain
	);

	void apply();
	ligand_options::option type() const{return random_conformer;}

private:
	std::set<core::Size> chains_;
	const std::set< protocols::ligand_docking::ResidueTorsionRestraintsOP > ligand_torsion_restraints_;

	void apply_chain( core::Size const chain_id );
	void apply_residue( core::Size const residue_id );
};

} //namespace ligand_options
} //namespace ligand_docking
} //namespace protocols

#endif
