// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file   core/pack/task/ResfileReader.cc
/// @brief  implementation of resfile reader and its command classes
/// @author Gordon Lemmon (glemmon@gmail.com)

// Unit Headers
#include <protocols/ligand_docking/ligand_options/Slide_together.hh>
#include <protocols/ligand_docking/ligand_options/InterfaceBuilder.hh>

#include <protocols/docking/DockingInitialPerturbation.hh>

// Utility Headers
#include <numeric/random/random.hh>
#include <utility/io/izstream.hh>
#include <utility/exit.hh>
#include <utility/assert.hh> //ASSERT_ONLY makes release build happy
#include <utility/string_util.hh>
#include <core/util/Tracer.hh>
#include <core/types.hh>
using core::util::T;
using core::util::Error;
using core::util::Warning;

namespace protocols {
namespace ligand_docking {
namespace ligand_options {


Slide_together::Slide_together(core::pose::Pose & pose) :
	LigandOptionCommand(pose), LigandSpecificCommand(pose),
			DefaultCommand(pose) {
}

void Slide_together::option(
		utility::vector1< std::string> const & tokens,
		core::Size const & ligand
) {
	if (tokens.size() != 1) {
		utility_exit_with_message("'slide together' doesn't take arguments");
	}
	core::Size jump_id= get_jump_id_from_chain_id(ligand, pose_);
	jump_ids_.insert(jump_id);
}

void Slide_together::option(
		utility::vector1< std::string> const & tokens,
		std::set<core::Size> const & ligands_to_dock
) {
	if (tokens.size() != 1) {
		utility_exit_with_message("'slide together' doesn't take arguments");
	}
	std::set<core::Size> ligand_jump_ids = get_jump_ids_from_chain_ids(ligands_to_dock, pose_);// TODO fix this so it defaults to all user specified ligands
	jump_ids_.insert(ligand_jump_ids.begin(), ligand_jump_ids.end());
}

void Slide_together::apply() {
	std::set<core::Size>::iterator i = jump_ids_.begin();
	for (; i != jump_ids_.end(); ++i) {
		protocols::docking::FaDockingSlideTogether slideTogether(*i);
		slideTogether.apply(pose_);
	}
}


} //namespace ligand_options
} //namespace ligand_docking
} //namespace protocols
