// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file   core/pack/task/ResfileReader.hh
/// @brief  header of classes for resfile options
/// @author Gordon Lemmon

#ifndef INCLUDED_protocols_ligand_docking_ligand_options_Slide_together_HH
#define INCLUDED_protocols_ligand_docking_ligand_options_Slide_together_HH

// Unit Headers
#include <protocols/ligand_docking/ligand_options/BaseOptions.hh>
#include <protocols/ligand_docking/ligand_options/LigandOptionMap.fwd.hh>

///////////////////////////////////////////////////////////////////////

namespace protocols {
namespace ligand_docking {
namespace ligand_options {

///@brief
class Slide_together : public LigandSpecificCommand, public DefaultCommand
{
public:
	Slide_together(core::pose::Pose & pose);

	void option(
		utility::vector1< std::string > const & tokens,
		core::Size const & ligand_chain_id
	);

	void option(
		utility::vector1< std::string > const & tokens,
		std::set<core::Size> const & ligands_to_dock
	);

	void apply();

	ligand_options::option type()const {return tether_ligand;}

private:
	//map of ligand jump_ids to stdev of tether
	std::set<core::Size> jump_ids_;
};

} //namespace ligand_options
} //namespace ligand_docking
} //namespace protocols

#endif
