// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file   core/pack/task/ResfileReader.hh
/// @brief  header of classes for resfile options
/// @author Gordon Lemmon

#ifndef INCLUDED_protocols_ligand_docking_ligand_options_Soft_rep_HH
#define INCLUDED_protocols_ligand_docking_ligand_options_Soft_rep_HH

// Unit Headers
#include <protocols/ligand_docking/ligand_options/BaseOptions.hh>
#include <protocols/ligand_docking/ligand_options/LigandOptionMap.fwd.hh>
//#include <protocols/ligand_docking/ligand_options/InterfaceBuilder.hh>

// Package Headers
//#include <core/pose/Pose.hh>
//#include <protocols/loops/LoopClass.hh>
#include <protocols/ligand_docking/ResidueTorsionRestraints.hh>

static core::util::Tracer Soft_rep_tracer("protocols.ligand_docking.SoftRep", core::util::t_debug);
///////////////////////////////////////////////////////////////////////

namespace protocols {
namespace ligand_docking {
namespace ligand_options {

class Soft_rep : public DefaultCommand //, public LigandSpecificCommand
{
public:
	Soft_rep(core::pose::Pose & pose);

	void apply();

	void option(
		utility::vector1< std::string > const & tokens,
		std::set<core::Size> const & /*ligands_to_dock*/
	);

	void restore_to_hard_rep();
//	void
//	option(
//		utility::vector1< std::string > const & /*tokens*/,
//		core::pose::Pose & pose,
//		std::string const & ligand_chain
//	);
	ligand_options::option type() const {return soft_rep;}

	const core::scoring::ScoreFunctionOP & get_score_fxn() const;/// TODO make this const.

private:
	bool soft_;
	bool old_estat_;
	core::scoring::ScoreFunctionOP score_fxn_;

	void tweak_scorefxn(
		std::string const & weights_tag,
		bool const old_estat,
		bool const hbonds_downweight=true
	);

	void add_score_terms_conditionally(bool old_estat, bool hbonds_downweight);
};

} //namespace ligand_options
} //namespace ligand_docking
} //namespace protocols

#endif
