// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file   core/pack/task/ResfileReader.hh
/// @brief  header of classes for resfile options
/// @author Gordon Lemmon

#ifndef INCLUDED_protocols_ligand_docking_ligand_options_Start_from_HH
#define INCLUDED_protocols_ligand_docking_ligand_options_Start_from_HH

// Unit Headers
#include <protocols/ligand_docking/ligand_options/BaseOptions.hh>
#include <protocols/ligand_docking/ligand_options/LigandOptionMap.fwd.hh>
//#include <protocols/ligand_docking/ligand_options/InterfaceBuilder.hh>

// Package Headers
//#include <core/pose/Pose.hh>
//#include <protocols/loops/LoopClass.hh>
//#include <protocols/ligand_docking/ResidueTorsionRestraints.hh>
//#include <protocols/moves/Mover.hh>
//#include <core/kinematics/MoveMap.hh>
//#include <core/pack/task/PackerTask.hh>
//
//// Project Headers
//#include <core/types.hh>
//#include <core/grid/CartGrid.hh>
//
//// Utility Headers
//#include <utility/vector1.hh>
//#include <utility/exit.hh>
//#include <core/util/Tracer.hh>
//
//
//// STL Headers
//#include <iosfwd>
//#include <map>
//#include <string>
//#include <set>

///////////////////////////////////////////////////////////////////////

namespace protocols {
namespace ligand_docking {
namespace ligand_options {

static core::util::Tracer start_from_tracer("protocols.ligand_docking.ligand_options.Start_from", core::util::t_debug);


class Start_from : public LigandSpecificCommand
{
public:
	Start_from(core::pose::Pose & pose);

	void option(
		utility::vector1< std::string > const & tokens,
		core::Size const & ligand
	);

	void apply();

	ligand_options::option type()const {return start_from;}

private:
	std::map<core::Size, utility::vector1<core::Vector> > chains_;
	std::map<core::Size, core::Vector> start_from_;

	core::Vector const
	split(std::string const s, char const token=',')const;

	core::Vector choose_desired_centroid(
			core::Size const jump_id,
			utility::vector1< core::Vector >  const start_from_pts
	)const;

	///@brief how can this compile!?  its a const function that applies a mover to pose_
	void move_ligand_to_desired_centroid(
		core::Size const jump_id,
		core::Vector const desired_centroid
	)const;
};

} //namespace ligand_options
} //namespace ligand_docking
} //namespace protocols

#endif
