// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file   core/pack/task/ResfileReader.hh
/// @brief  header of classes for resfile options
/// @author Gordon Lemmon

#ifndef INCLUDED_protocols_ligand_docking_ligand_options_Tether_ligand_HH
#define INCLUDED_protocols_ligand_docking_ligand_options_Tether_ligand_HH

// Unit Headers
#include <protocols/ligand_docking/ligand_options/BaseOptions.hh>
#include <protocols/ligand_docking/ligand_options/LigandOptionMap.fwd.hh>
//#include <protocols/ligand_docking/ligand_options/InterfaceBuilder.hh>

// Package Headers
//#include <protocols/ligand_docking/ResidueTorsionRestraints.hh>

///////////////////////////////////////////////////////////////////////

namespace protocols {
namespace ligand_docking {
namespace ligand_options {

///@brief
class Tether_ligand : public LigandSpecificCommand, public DefaultCommand
{
public:
	Tether_ligand(core::pose::Pose & pose);

	void option(
		utility::vector1< std::string > const & tokens,
		core::Size const & ligand
	);

	void option(
			utility::vector1< std::string > const & tokens,
			std::set<core::Size> const & ligands_to_dock
	);

	void apply();

	ligand_options::option type()const {return tether_ligand;}

	void release();

	std::set<core::scoring::constraints::ConstraintCOP> const &
	get_const_ligand_tethers_reference() const;

private:
	//map of chain_ids to stdev of tether
	std::map<core::Size, core::Real > chains_;
	std::set<core::scoring::constraints::ConstraintCOP> ligand_tethers_;

	core::scoring::constraints::ConstraintCOP
	restrain_ligand_nbr_atom(
		core::Size const lig_id,
		core::Real const stddev_Angstroms
	) const;
};

} //namespace ligand_options
} //namespace ligand_docking
} //namespace protocols

#endif
