// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file   core/pack/task/ResfileReader.hh
/// @brief  header of classes for resfile options
/// @author Gordon Lemmon

#ifndef INCLUDED_protocols_ligand_docking_ligand_options_Translate_HH
#define INCLUDED_protocols_ligand_docking_ligand_options_Translate_HH

// Unit Headers
#include <protocols/ligand_docking/ligand_options/BaseOptions.hh>
#include <protocols/ligand_docking/ligand_options/LigandOptionMap.fwd.hh>

//// Project Headers
#include <core/grid/CartGrid.hh>

///////////////////////////////////////////////////////////////////////

namespace protocols {
namespace ligand_docking {
namespace ligand_options {

static core::util::Tracer translate_tracer("protocols.ligand_docking.ligand_options.translate", core::util::t_debug);

struct Translate_info{ // including default values
public:
	Distribution distribution;
	core::Real angstroms;
	core::Size cycles;
	Translate_info(): distribution(uniform), angstroms(0), cycles(0){};
};

class Translate : public InitialMoverOption
{
public:
	Translate(core::pose::Pose & pose);

	void option(
		utility::vector1< std::string > const & tokens,
		std::set<core::Size> const & ligands_to_dock
	);

	void option(
		utility::vector1< std::string > const & tokens,
		core::Size const & ligand
	);
	void apply();

	ligand_options::option type()const {return translate;}

private:
	// this is a map<chain_id, num_of_cycles>
	std::map<core::Size, Translate_info> chains_;
	//std::map<core::Size, core::grid::CartGridOP>grids_;

	void option(
		core::Size const & num_cycles,
		std::set<core::Size> const & ligands_to_dock
	);

	Translate_info
	parse_tokens(
			utility::vector1< std::string> const & tokens
	);// cannot make this const because of std::map::operator[] usage

	void option(
			Translate_info translate_info,
			std::set<core::Size> const & ligands_to_dock
	);

	void apply(
			core::Size chain_id,
			Translate_info const translate_info,
			utility::vector1<core::Size> chains_to_exclude
	);

	void translate_ligand(
			core::grid::CartGridOP const & grid,
			core::Size const jump_id,
			Translate_info const translate_info
	);
};

} //namespace ligand_options
} //namespace ligand_docking
} //namespace protocols

#endif
