// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.
/*
 * chain_functions.hh
 *
 *  Created on: Nov 6, 2008
 *      Author: lemmongh
 */

#ifndef INCLUDED_protocols_ligand_docking_ligand_options_chain_functions_HH
#define INCLUDED_protocols_ligand_docking_ligand_options_chain_functions_HH

#include <core/types.hh>
#include <core/pose/Pose.fwd.hh>
#include <set>
#include <core/util/Tracer.hh>

namespace protocols {
namespace ligand_docking {
namespace ligand_options {

static core::util::Tracer chain_functions_tracer("protocols.ligand_docking.ligand_options.chain_functions", core::util::t_debug);

std::set<core::Size>
get_jump_ids_from_chain_ids(std::set<core::Size> const chain_ids, core::pose::Pose const & pose);

core::Size
get_jump_id_from_chain_id(core::Size const & chain_id, core::pose::Pose const & pose);

std::set<core::Size>
get_chain_ids(core::pose::Pose const & pose);

core::Size
get_chain_id_from_chain(std::string const & chain, core::pose::Pose const & pose);

char
get_chain_from_chain_id(core::Size const & chain_id, core::pose::Pose const & pose);

core::Size
get_chain_id_from_jump_id(core::Size const & jump_id, core::pose::Pose const & pose);

char
get_chain_from_jump_id(core::Size const & jump_id, core::pose::Pose const & pose);

core::Size num_heavy_atoms(
	core::Size begin,
	core::Size const end,
	core::pose::Pose const & pose
);

core::Size
num_chi_angles(
	core::Size begin,
	core::Size const end,
	core::pose::Pose const & pose
);

}
}
}

#endif
