// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file   protocols/ligand_docking/LigandDockProtocol.hh
///
/// @brief
/// @author Gordon Lemmon


#ifndef INCLUDED_protocols_ligand_docking_ligand_scores_HH
#define INCLUDED_protocols_ligand_docking_ligand_scores_HH

#include <protocols/jd2/Job.hh>
#include <core/scoring/ScoreFunction.fwd.hh>

#include <core/pose/Pose.fwd.hh>
#include <protocols/moves/Mover.hh>
#include <core/util/Tracer.hh>

namespace protocols {
namespace ligand_docking {

static core::util::Tracer ligand_scores_tracer("protocols.ligand_docking.ligand_scores", core::util::t_debug);

///@brief append interface_delta scores
void
append_interface_deltas(
		int const jump_id,
		protocols::jd2::JobOP job,
		core::pose::Pose const & after,
		const core::scoring::ScoreFunctionOP scorefxn
);

void
append_ligand_travel(
		int const jump_id,
		protocols::jd2::JobOP job,
		core::pose::Pose const & before,
		core::pose::Pose const & after
);

void
append_radius_of_gyration(
		int const jump_id,
		protocols::jd2::JobOP job,
		core::pose::Pose const & before
);

void
append_ligand_RMSD(
		int const jump_id,
		protocols::jd2::JobOP job,
		core::pose::Pose const & before,
		core::pose::Pose const & after
);

} // namespace ligand_docking
} // namespace protocols

#endif // INCLUDED_protocols_ligand_docking_ligand_scores_HH
