// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file src/protocols/abinitio/CcdLoopClosureMover.hh
/// @brief header file for CcdLoopClosureMover protocol
/// @detailed
///	  Contains currently: Classic Abinitio
///
///
/// @author Oliver Lange



#ifndef INCLUDED_protocols_loops_CcdLoopClosureMover_HH
#define INCLUDED_protocols_loops_CcdLoopClosureMover_HH

// Unit Headers

// Package Headers
#include <protocols/loops/LoopClass.hh>

// Project Headers
#include <core/pose/Pose.fwd.hh>
#include <core/kinematics/MoveMap.hh>
#include <protocols/moves/Mover.hh>

// ObjexxFCL Headers

// Utility headers
#include <core/types.hh>
#include <utility/pointer/ReferenceCount.hh>

//// C++ headers
#include <cstdlib>
#include <string>
#include <vector>

namespace protocols {
namespace loops {

/// Move these forward declarations to CcdLoopClosureMover.fwd.hh
class CcdLoopClosureMover;
typedef utility::pointer::owning_ptr< CcdLoopClosureMover > CcdLoopClosureMoverOP;
typedef utility::pointer::owning_ptr< CcdLoopClosureMover const > CcdLoopClosureMoverCOP;

//wrapper for fast_ccd_loop_closure
class CcdLoopClosureMover : public moves::Mover {
public:
  CcdLoopClosureMover(
     Loop const& loop_def,
     core::kinematics::MoveMapCOP mm
  );

  virtual void apply( core::pose::Pose &pose );

  core::Real forward_deviation() const {
    return forward_deviation_;
  }

  core::Real backward_deviation() const {
    return backward_deviation_;
  }

	bool success() const {
		return ( forward_deviation() < tolerance_ ) && ( backward_deviation() < tolerance_ );
	}

private:
  Loop loop_;
  core::kinematics::MoveMapCOP movemap_;
  core::Real max_rama_score_increase_;
  core::Real max_total_delta_helix_;
  core::Real max_total_delta_strand_;
  core::Real max_total_delta_loop_;
  core::Real tolerance_;

  Size ccd_cycles_;
  bool bRama_check_;

  core::Real forward_deviation_; // output
  core::Real backward_deviation_; // output
  core::Real torsion_delta_;
  core::Real rama_delta_;

  Size actual_cycles_;
};

class CcdMover : public moves::Mover {
public:
  CcdMover(
     Loop const& loop_def,
     core::kinematics::MoveMapCOP mm
  );

  virtual void apply( core::pose::Pose &pose );

private:
	core::Size total_moves_;
  Loop loop_;
  core::kinematics::MoveMapCOP movemap_;
};

}
}

#endif
