// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file
/// @brief
/// @author Mike Tyka
/// @author Daniel J. Mandell

#ifndef INCLUDED_protocols_loops_LoopMover_KIC_HH
#define INCLUDED_protocols_loops_LoopMover_KIC_HH


#include <protocols/loops/LoopMover.hh>
#include <protocols/moves/Mover.hh>

#include <core/types.hh>
#include <core/util/Tracer.fwd.hh>
#include <core/scoring/ScoreFunction.fwd.hh>
#include <core/pack/task/TaskFactory.hh>
#include <core/kinematics/MoveMap.fwd.hh>
#include <core/kinematics/FoldTree.hh>
#include <core/id/types.hh>
#include <core/pose/Pose.fwd.hh>
#include <core/scoring/ScoreType.hh>

// C++ Headers


///////////////////////////////////////////////////////////////////////////////
namespace protocols {
namespace loops {



class LoopMover_Perturb_KIC: public IndependentLoopMover {
public:

	LoopMover_Perturb_KIC(
		protocols::loops::Loops  loops_in
	);

	LoopMover_Perturb_KIC(
		protocols::loops::Loops  loops_in,
		core::scoring::ScoreFunctionOP  scorefxn
	);


	virtual void  set_extended_torsions(
		core::pose::Pose & pose,
		Loop const & loop
	);

	void set_default_settings();

	/// @brief Clone this object
	virtual protocols::moves::MoverOP clone() const {
		return new LoopMover_Perturb_KIC(*this);
	}

	LoopResult model_loop( core::pose::Pose & pose,
	                 protocols::loops::Loop const & loop );

private:

	core::Size max_seglen_; // maximum KIC segment length
	bool recover_low_;
	core::Size max_kic_build_attempts_;
	core::Size remodel_kic_attempts_;
};




class LoopMover_Refine_KIC: public LoopMover {
public:
	LoopMover_Refine_KIC(
		protocols::loops::Loops  loops_in
	);

	LoopMover_Refine_KIC(
		protocols::loops::Loops  loops_in,
		core::scoring::ScoreFunctionOP  scorefxn
	);

	void set_default_settings();

	void set_redesign_loop( bool value = true ){ redesign_loop_ = value; }
	bool get_redesign_loop(){ return redesign_loop_; }

	void set_task_factory( core::pack::task::TaskFactoryOP value ){ task_factory = value; }
	bool get_task_factory(){ return task_factory; }

	/// @brief Clone this object
	virtual protocols::moves::MoverOP clone() const {
		return new LoopMover_Refine_KIC(*this);
	}

	void apply( core::pose::Pose & pose );

	///@brief change current map/tree to tweaked ones (if exists)
	void
	pre_min_map_tree_changes(
    core::kinematics::MoveMap & current_mm,
		core::pose::Pose & current_pose );

	///@brief change current map/tree to defaults
	void
	post_min_map_tree_changes(
		core::kinematics::MoveMap & current_mm,
		core::pose::Pose & current_pose );

	//@brief movemap --> which dofs can be moved during loops
	core::kinematics::MoveMap default_movemap_;
  core::kinematics::MoveMap tweaked_movemap_;

	///@brief foldtree to define minimizer behavior
	core::kinematics::FoldTree default_foldtree_;
	core::kinematics::FoldTree tweaked_foldtree_;

	///@brief indicates if default movemap/foldtree has changed or not
	bool movemap_tweak_;
	bool foldtree_tweak_;

protected:

	core::pack::task::TaskFactoryOP task_factory;
	bool redesign_loop_;

private:

	core::Real neighbor_dist_; // CB distance to loop to consider scaffold side-chain for rot trials, repack, dfpmin
	core::Size max_seglen_; // maximum KIC segment length
	bool recover_low_;
};



} //namespace loops
} //namespace protocols

#endif //INCLUDED_protocols_loops_LoopMover_KIC_HH
