// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file JumpSetup
/// @brief read jump-definition file   setups fold tree an chainbreak variants
/// loop code didn't work because fold-tree to complicated ( overlapping loops )
/// @detailed
/// @author Oliver Lange


#ifndef INCLUDED_protocols_loops_util_HH
#define INCLUDED_protocols_loops_util_HH

// Project Headers
#include <core/pose/Pose.fwd.hh>
#include <protocols/loops/LoopClass.fwd.hh>
#include <core/types.hh>
#include <utility/vector1.hh>
#include <core/fragment/FragSet.fwd.hh>
#include <core/scoring/ScoreFunction.hh>
namespace protocols {
namespace loops {

//@brief adds coord constraints for the atoms that are not in the loops structure
void fix_with_coord_cst( loops::Loops const& rigid, core::pose::Pose& pose, bool bCstAllAtom, utility::vector1< core::Real >& );


//@brief finds protein loops from dssp definitions - useful if you want to redesign all loops in a pose
void loopfinder(  core::pose::Pose & pose , loops::Loops & loops );

///@brief get frags that are fully within the Loop --- shorten(=true/false) frags that are close to the end of loops.
extern void select_loop_frags(
				 loops::Loops const& loops,
				 core::fragment::FragSet& source,
				 core::fragment::FragSet& loop_frags,
				 core::Size min_size = 1 /* set to 0 if you don't want to shorten at all */
);

void set_extended_torsions_and_idealize_loops( core::pose::Pose& pose, loops::Loops loops );
// add another version that uses loop object

void addScoresForLoopParts(
	core::pose::Pose& pose,
	loops::Loops loops,
	const core::scoring::ScoreFunction &scorefxn,
	core::pose::Pose& native_pose, core::Size nloops
);

} //loops
} //protocols

#endif
