// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
// :noTabs=false:tabSize=4:indentSize=4:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file   protocols/match/output/PDBWriter.hh
/// @brief
/// @author Florian Richter (floric@u.washington.edu) june 2009

#ifndef INCLUDED_protocols_match_output_PDBWriter_HH
#define INCLUDED_protocols_match_output_PDBWriter_HH

// Unit headers
#include <protocols/match/output/PDBWriter.fwd.hh>

// Package Headers
#include <core/conformation/Residue.fwd.hh>

#include <protocols/match/Hit.fwd.hh>
#include <protocols/match/MatcherTask.fwd.hh>
#include <protocols/match/downstream/DownstreamBuilder.hh>
#include <protocols/match/output/OutputWriter.hh>
#include <protocols/match/output/UpstreamHitCacher.fwd.hh>
#include <protocols/match/output/WriteUpstreamCoordinateKineamge.fwd.hh>

// Utility headers
#include <utility/pointer/ReferenceCount.hh>

// C++ headers
#include <map>
#include <set>

namespace protocols {
namespace match {
namespace output {

class PDBWriter : public OutputWriter
{

public:
	typedef std::pair< core::Size, core::Size > SizePair;

	typedef OutputWriter Parent;

public:

	PDBWriter();

	virtual ~PDBWriter();

	virtual
	void
	prepare_for_output_writing();

	virtual
	void
	record_match( match const & m );

	virtual
	void
	record_match( match_dspos1 const & m );

	void
	set_coordinate_cacher( UpstreamHitCacherOP );

	void
	set_prefix( std::string const & prefix );

	void
	initialize_from_matcher_task(
			MatcherTaskCOP mtask
	);

	void
	set_downstream_builder(
		Size geomcst_id,
		downstream::DownstreamBuilderCOP dsbuilder
	);

	void
	assemble_remark_lines(
		core::pose::Pose & outpose,
		utility::vector1< core::conformation::ResidueCOP > const & upstream_matchres,
		std::map< core::Size, core::Size > const & redundant_upstream_res,
		core::pose::Pose const & downstream_pose,
		utility::vector1< core::Size > const & ex_geom_ids_for_upstream_res
	) const;

	core::pose::PoseCOP
	create_output_upstream_pose(
		utility::vector1< core::conformation::ResidueCOP > const & upstream_matchres,
		std::map< core::Size, core::Size > const & redundant_upstream_res,
		utility::vector1< core::Size > & matchres_seqpos,
		core::pose::Pose const & one_ds_pose,
		utility::vector1< core::Size > const & ex_geom_ids_for_upstream_res
	);

protected:

	std::string
	assemble_outtag(
		utility::vector1< core::conformation::ResidueCOP > const & upstream_matchres
	);


private:

	UpstreamHitCacherOP coordinate_cacher_;

	// whether to write the whole pose or only the matched residues
	bool write_matchres_only_;

	std::string scaf_name_, cstfile_name_, prefix_;

	core::Size num_written_;

	//needed to build the downstream target for pdb writing
	utility::vector1< downstream::DownstreamBuilderCOP > dsbuilders_;

	//
	core::pose::PoseCOP orig_upstream_pose_;

	//map to keep track of the output names
	std::map< std::string, SizePair > signature_map_;

	//which of the cst res to write separate matches for
	utility::vector1< bool > output_dsgeom_for_geomcst_;

};

}
}
}

#endif
