// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
// :noTabs=false:tabSize=4:indentSize=4:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file   protocols/match/output/SameSequenceGrouper.cc
/// @brief
/// @author Alex Zanghellini (zanghell@u.washington.edu)
/// @author Andrew Leaver-Fay (aleaverfay@gmail.com), porting to mini

// Unit headers
#include <protocols/match/output/SameSequenceGrouper.hh>

// Package headers
#include <protocols/match/Hit.hh>
#include <protocols/match/output/UpstreamHitCacher.hh>

// Project headers
#include <core/conformation/Residue.hh>

// Utility headers
#include <utility/exit.hh>

namespace protocols {
namespace match {
namespace output {

SameSequenceGrouper::SameSequenceGrouper() : n_geometric_constraints_( 0 ) {}
SameSequenceGrouper::SameSequenceGrouper( Size ncst ) : n_geometric_constraints_( ncst ) {}

SameSequenceGrouper::~SameSequenceGrouper() {}

SameSequenceGrouper::Size
SameSequenceGrouper::assign_group_for_match(
	match const & m
)
{
	return assign_group_for_match( match_dspos1( m, 1 ) );
}

SameSequenceGrouper::Size
SameSequenceGrouper::assign_group_for_match(
	match_dspos1 const & m
)
{
	runtime_assert( m.upstream_hits.size() == n_geometric_constraints_ );

	utility::vector1< Size > seq_vector( n_geometric_constraints_ * 2, 0 );
	for ( Size ii = 1; ii <= n_geometric_constraints_; ++ii ) {
		seq_vector[ ii ] = m.upstream_hits[ ii ].scaffold_build_id();
		seq_vector[ n_geometric_constraints_ + ii ] =
			hit_cacher_->upstream_conformation_for_hit( ii, fake_hit( m.upstream_hits[ ii ] ) )->aa();
	}

	SequenceMap::const_iterator iter = sequence_indexer_.find( seq_vector );
	if ( iter == sequence_indexer_.end() ) {
		Size next_index = sequence_indexer_.size() + 1;
		sequence_indexer_[ seq_vector ] = next_index;
		return next_index;
	} else {
		return iter->second;
	}
}

void
SameSequenceGrouper::reset()
{
	sequence_indexer_.clear();
}

void
SameSequenceGrouper::set_n_geometric_constraints( Size n_csts )
{
	n_geometric_constraints_ = n_csts;
}

void
SameSequenceGrouper::set_hit_cacher( UpstreamHitCacherOP cacher )
{
	hit_cacher_ = cacher;
}



}
}
}
