// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file Motif.hh
/// @brief Header for interaction motif between residues
/// @author havranek

#ifndef INCLUDED_protocols_motifs_Motif_HH
#define INCLUDED_protocols_motifs_Motif_HH

#include <core/types.hh>
#include <core/pose/Pose.fwd.hh>
#include <core/conformation/Residue.fwd.hh>
#include <core/kinematics/Stub.fwd.hh>
#include <core/kinematics/Jump.hh>

#include <utility/pointer/ReferenceCount.hh>

#include <string>

namespace protocols {
namespace motifs {

class Motif : public utility::pointer::ReferenceCount
{

public:
	Motif( std::string & resname1,
			std::string & res1_atom1, std::string & res1_atom2, std::string & res1_atom3,
			std::string & resname2,
			std::string & res2_atom1, std::string & res2_atom2, std::string & res2_atom3,
			core::kinematics::Jump const & orientation );
	virtual ~Motif(){};
	virtual bool apply_check( core::pose::Pose const & pose, core::Size pos );
	virtual void place_residue( core::conformation::Residue const & fixed, core::conformation::Residue & mobile );
	virtual void place_residue_( core::conformation::Residue const & fixed, core::conformation::Residue & mobile, bool forward );
	core::kinematics::Jump const & get_jump();

private:
	int _id;
	std::string const restype_name1_;
	std::string const res1_atom1_name_;
	std::string const res1_atom2_name_;
	std::string const res1_atom3_name_;
	std::string const restype_name2_;
	std::string const res2_atom1_name_;
	std::string const res2_atom2_name_;
	std::string const res2_atom3_name_;
	core::kinematics::Jump const forward_jump_;
	core::kinematics::Jump const backward_jump_;
};

class SingleMotif : public Motif {

public:
	SingleMotif( std::string & resname1,
			std::string & res1_atom1, std::string & res1_atom2, std::string & res1_atom3,
			std::string & resname2,
			std::string & res2_atom1, std::string & res2_atom2, std::string & res2_atom3,
			core::kinematics::Jump const & orientation );

};


class DoubleMotif : public Motif {

};


}
}

#endif // INCLUDED_protocols_motifs_Motif
