// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file protocols/motifs/MotifLibrary.cc
/// @brief Implmentation of interaction motifs

#include <protocols/motifs/Motif.fwd.hh>
#include <protocols/motifs/MotifLibrary.hh>

namespace protocols {
namespace motifs {

// Class methods

void
MotifLibrary::add_to_library( Motif const & add_me )
{
	library_.push_back( new Motif( add_me ) );
}

core::Size
MotifLibrary::nmotifs()
{
	return library_.size();
}

}
}
