// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file MotifLibrary.hh
/// @brief class declaration for sets of interaction motifs between residues
/// @author havranek


#ifndef INCLUDED_protocols_motifs_MotifLibrary_HH
#define INCLUDED_protocols_motifs_MotifLibrary_HH

#include <protocols/motifs/Motif.hh>
#include <protocols/motifs/MotifLibrary.fwd.hh>
#include <core/types.hh>

namespace protocols {
namespace motifs {

class MotifLibrary{

public:
	void add_to_library( protocols::motifs::Motif const & new_motif );
	core::Size nmotifs();

private:
	MotifCOPs library_;
};

}
}

#endif // INCLUDED_protocols_motifs_MotifLibrary
