// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file motif_utils.hh
/// @brief Header for motif helper/conversion/io functions
/// @author havranek

#include <core/types.hh>

#include <protocols/motifs/motif_utils.hh>

#include <core/kinematics/RT.hh>
#include <core/kinematics/Jump.hh>

namespace protocols {
namespace motifs {

	using namespace core;
	using namespace kinematics;

  Jump jump_from_old_style_motif(
    Real trans_x,
    Real trans_y,
    Real trans_z,
    Real Euler_phi,
    Real Euler_psi,
    Real Euler_theta
  )
	{
		Jump ret_val;

//		Euler_theta = -1.0*( numeric::constants::d::pi - Euler_theta );

		Real cos_phi( cos( Euler_phi ) );
		Real sin_phi( sin( Euler_phi ) );
		Real cos_psi( cos( Euler_psi ) );
		Real sin_psi( sin( Euler_psi ) );
		Real cos_theta( cos( Euler_theta ) );
		Real sin_theta( sin( Euler_theta ) );

		numeric::xyzMatrix< Real > temp_mat;

		temp_mat( 1, 1 ) = cos_psi*cos_phi - cos_theta*sin_phi*sin_psi;
		temp_mat( 1, 2 ) = cos_psi*sin_phi + cos_theta*cos_phi*sin_psi;
		temp_mat( 1, 3 ) = sin_psi*sin_theta;
		temp_mat( 2, 1 ) = (-1.0)*sin_psi*cos_phi - cos_theta*sin_phi*cos_psi;
		temp_mat( 2, 2 ) = (-1.0)*sin_psi*sin_phi + cos_theta*cos_phi*cos_psi;
		temp_mat( 2, 3 ) = cos_psi*sin_theta;
		temp_mat( 3, 1 ) = sin_theta*sin_phi;
		temp_mat( 3, 2 ) = (-1.0)*sin_theta*cos_phi;
		temp_mat( 3, 3 ) = cos_theta;

//		temp_mat( 1, 1 ) = cos_psi*cos_phi - cos_theta*sin_phi*sin_psi;
//		temp_mat( 2, 1 ) = cos_psi*sin_phi + cos_theta*cos_phi*sin_psi;
//		temp_mat( 3, 1 ) = sin_psi*sin_theta;
//		temp_mat( 1, 2 ) = (-1.0)*sin_psi*cos_phi - cos_theta*sin_phi*cos_psi;
//		temp_mat( 2, 2 ) = (-1.0)*sin_psi*sin_phi + cos_theta*cos_phi*cos_psi;
//		temp_mat( 3, 2 ) = cos_psi*sin_theta;
//		temp_mat( 1, 3 ) = sin_theta*sin_phi;
//		temp_mat( 2, 3 ) = (-1.0)*sin_theta*cos_phi;
//		temp_mat( 3, 3 ) = cos_theta;

		Vector start_vec( trans_x, trans_y, trans_z );
//		Vector test_vec( temp_mat*start_vec );
		ret_val.set_translation( start_vec );
		ret_val.set_rotation( temp_mat );

		return ret_val;
	}

}
}

