// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file motif_utils.hh
/// @brief Header for motif helper/conversion/io functions
/// @author havranek

#ifndef INCLUDED_protocols_motifs_motif_utils_HH
#define INCLUDED_protocols_motifs_motif_utils_HH

#include <core/types.hh>

#include <core/kinematics/Jump.fwd.hh>

namespace protocols {
namespace motifs {
	using namespace core;
	using namespace kinematics;

	Jump jump_from_old_style_motif(
		Real trans_x,
		Real trans_y,
		Real trans_y,
		Real Euler_phi,
		Real Euler_psi,
		Real Euler_theta
	);

}
}

#endif // INCLUDED_protocols_motifs_motif_utils
