// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file moves/CDRH3Modeler.hh
/// @brief
/// @author Aroop Sircar (aroopsircar@yahoo.com)


#ifndef INCLUDED_protocols_moves_CDRH3Modeler_HH
#define INCLUDED_protocols_moves_CDRH3Modeler_HH


// Rosetta headers
#include <core/fragment/FragSet.fwd.hh>
#include <core/fragment/FragData.fwd.hh>
#include <core/pose/Pose.hh>
#include <core/scoring/ScoreFunction.hh>

#include <protocols/antibody/AntibodyClass.hh>

#include <protocols/loops/LoopClass.fwd.hh>
#include <protocols/moves/Mover.hh>
#include <protocols/moves/PackRotamersMover.hh>

// ObjexxFCL Headers

// C++ Headers

// Utility Headers
#include <utility/vector1.fwd.hh>

namespace protocols {
	namespace moves {

		class CDRH3Modeler;
		typedef utility::pointer::owning_ptr< CDRH3Modeler > CDRH3ModelerOP;
		typedef utility::pointer::owning_ptr< const CDRH3Modeler > CDRH3ModelerCOP;

		//////////////////////////////////////////////////////////////////////////
		/// @brief Ab initio modeling of CDR H3 loop
		/// @details
		class CDRH3Modeler : public Mover {
		public:
			// default constructor
			CDRH3Modeler();

			utility::vector1< core::fragment::FragSetOP > cdr_frag_libs;

			void set_default();
			virtual void apply( core::pose::Pose & pose_in );

			// insert C-terminal fragments
			void antibody_modeling_insert_ter( antibody::Antibody & antibody_in );

			// store CDR H3 C-terminal fragments
			void store_H3_cter_fragment(
			  utility::vector1< core::fragment::FragData > & base_library_in );

			// store CDR H3 loop fragments
			void store_frags(
 			  utility::vector1< core::fragment::FragSetOP > new_libs );

			// return false if any cdr cutpoint is broken
			bool cutpoints_separation( antibody::Antibody & antibody_in );

			// Compute the separation at the cutpoint. The N-C distance of the
			// peptide bond which should be formed at the cutpoint. A closed loop is
			// assumed to have a gap < 1.9 Ang
			core::Real cutpoint_separation( core::pose::Pose & pose_in,
																			Size cutpoint );

			// CDR H3 C-terminal fragments
			utility::vector1< core::fragment::FragData > H3_base_library;

			// CDR H3 loop fragments
			utility::vector1< core::fragment::FragSetOP > frag_libs_;

		private:
			core::pose::Pose template_pose_;
			/// @brief Number of ADDITIONAL residues modeled from H3_CTERM
			///        These residues range from H:n-2,n-1,n,n+1 of H3
			Size base_;
			Size c_ter_stem_;
			// true if command line option "model_h3" is set
			// enables modeling of CDR H3 loop
			bool do_h3_modeling_;
			core::scoring::ScoreFunctionOP fa_scorefxn_;

		}; // class CDRH3Modeler

		// read CDR H3 C-terminal fragments (size: 4)
		void read_H3_cter_fragment(	antibody::Antibody & antibody_in,
			utility::vector1< core::fragment::FragData > & H3_base_library );

		void simple_one_loop_fold_tree( core::pose::Pose & pose,
																		loops::Loop const & loop );

	} // moves
} // protocols


#endif
