// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file moves/GraftMover.hh
/// @brief
/// @author Aroop Sircar (aroopsircar@yahoo.com)


#ifndef INCLUDED_protocols_moves_GraftMover_HH
#define INCLUDED_protocols_moves_GraftMover_HH


// Rosetta headers
#include <core/pose/Pose.hh>
#include <protocols/moves/Mover.hh>
#include <protocols/moves/PackRotamersMover.hh>

// ObjexxFCL Headers

// C++ Headers

// Utility Headers

namespace protocols {
	namespace moves {

		class GraftMover;
		typedef utility::pointer::owning_ptr< GraftMover > GraftMoverOP;
		typedef utility::pointer::owning_ptr< const GraftMover > GraftMoverCOP;

		//////////////////////////////////////////////////////////////////////////
		/// @brief Grafts a series of CDR onto a framework
		/// @details
		class GraftMover : public Mover {
		public:
			// default constructor
			GraftMover();

			void set_default();
			virtual void apply( core::pose::Pose & pose_in );

		private:
			// Grafting options
			bool graft_l1_;
			bool graft_l2_;
			bool graft_l3_;
			bool graft_h1_;
			bool graft_h2_;
			bool graft_h3_;

			// Packer
			moves::PackRotamersMoverOP packer_;

			void set_packer_default(
				core::pose::Pose & pose_in,
  			core::scoring::ScoreFunctionOP scorefxn,
				bool include_current );
		}; // class GraftMover

		class GraftOneMover;
		typedef utility::pointer::owning_ptr< GraftOneMover > GraftOneMoverOP;
		typedef utility::pointer::owning_ptr<const GraftOneMover> GraftOneMoverCOP;

		//////////////////////////////////////////////////////////////////////////
		/// @brief Grafts only one CDR onto a framework
		/// @details
		class GraftOneMover : public Mover {
		public:
			// default constructor
			//GraftOneMover();
			// constructor with arguments
			GraftOneMover(
				Size query_start,
				Size query_end,
				std::string template_name );

			void set_default();
			virtual void apply( core::pose::Pose & pose_in );

		private:
			// Limits of query loop
			Size query_start_;
			Size query_end_;
			// Limits of template loop
			Size template_start_;
			Size template_end_;
			std::string template_name_;
			core::pose::Pose template_pose_;

		}; // class GraftOneMover
	} // moves
} // protocols


#endif
