// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file /protocols/moves/KinematicWrapper.hh
/// @brief wrapper for KinematicMover - useful when only apply() is available
/// @author Steven Lewis

#ifndef INCLUDED_protocols_moves_KinematicWrapper_HH
#define INCLUDED_protocols_moves_KinematicWrapper_HH

// Unit Headers
#include <protocols/moves/KinematicWrapper.fwd.hh>
#include <protocols/moves/KinematicMover.fwd.hh>

// Project Headers
#include <core/pose/Pose.fwd.hh>
#include <protocols/moves/Mover.hh>

#include <protocols/loops/LoopClass.fwd.hh>

// Utility Headers
#include <core/types.hh>

namespace protocols {
namespace moves {

///@details This class extends KinematicMover by composition (has-a KinematicMover).  The idea is to make KinematicMover useful when ONLY the apply() function is available (as in MoverContainers, etc.).  It will reapply KinematicMover until the KinematicMover reports a success.  This class uses searches through loop begin/middle/end points while searching for solutions.
class KinematicWrapper : public protocols::moves::Mover {

public:
	///@brief ctor with Loop
	KinematicWrapper(
									 protocols::moves::KinematicMoverOP kinmover_in,
									 protocols::loops::Loop loop,
									 core::Size cycles = 0 //0 is sentinel value to check options system
	);

	///@brief ctor with explicit loop begin/end
	KinematicWrapper(
									 protocols::moves::KinematicMoverOP kinmover_in,
									 core::Size loop_begin,
									 core::Size loop_end,
									 core::Size cycles = 0 //0 is sentinel value to check options system
	);

	virtual ~KinematicWrapper();

	virtual void apply( core::pose::Pose & pose );

private:
	///@brief OP for KinematicMover
	protocols::moves::KinematicMoverOP kinmover_;

	///@brief the loop this object-instance remodels
	//protocols::loops::Loop loop_;
	core::Size const loop_begin_;
	core::Size const loop_end_;

	///@brief a limit on the number of cycles the mover will run
	core::Size const limit_;
};//end KinematicWrapper

}//namespace moves
}//namespace protocols

#endif // INCLUDED_protocols_moves_KinematicWrapper_HH
