// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file MoverContainer.cc
/// @brief apply functions for classes of type MoverContainer
/// @detailed
/// @author Monica Berrondo

#include <protocols/moves/MoverContainer.hh>

// Rosetta Headers
#include <core/pose/Pose.hh>
#include <core/kinematics/MoveMap.hh>
#include <core/util/basic.hh>
#include <core/util/Tracer.hh>

#include <protocols/moves/MonteCarlo.hh>

// ObjexxFCL Headers
#include <ObjexxFCL/formatted.o.hh>

// Random number generator
#include <numeric/random/random.hh>

//
#include <string>

static core::util::Tracer tr("protocols.moves.MoverContainer");


namespace protocols {
namespace moves {

static numeric::random::RandomGenerator RG(114);  // <- Mike's Magic number, do not change it (and dont try and use it anywhere else) !!! what a retarded system ... %-|

using namespace core;
using core::util::T;
using core::util::Error;
using core::util::Warning;

void MoverContainer::add_mover( MoverOP mover_in , Real weight_in ) // do we need weights?
{
	movers_.push_back(mover_in);
	weight_.push_back(weight_in);
}

// Sets the input pose for both the container and the contained movers
// overriding this method fixes an annoying bug (barak)
	// TODO: does it make sense to cal this also from add_mover? I think not (barak)
void MoverContainer::set_input_pose( PoseCOP pose ){
	this->Mover::set_input_pose( pose );
	for ( Size i=0; i<movers_.size(); ++i ) {
		movers_[i]->set_input_pose( pose );
	}
}

// Sets the native pose for both the container and the contained movers
// overriding this method fixes an annoying bug (barak)
// TODO: does it make sense to call this also from add_mover? I think not (barak)
void MoverContainer::set_native_pose( PoseCOP pose ){
	this->Mover::set_native_pose( pose );
	for ( Size i=0; i<movers_.size(); ++i ) {
		movers_[i]->set_native_pose( pose );
	}
}

void SequenceMover::apply( core::pose::Pose & pose )
{
	type("");
	for ( Size i=0; i<movers_.size(); ++i ) {
		movers_[i]->apply( pose );
		type( type()+movers_[i]->type() );
	}
}

void RandomMover::apply( core::pose::Pose & pose )
{
	Real weight_sum(0.0);
	size_t m;
	for(m=0;m< movers_.size(); m++){
		weight_sum += weight_[m];
	}
	type("");
	for(Size i=0;i< nmoves_; i++)
	{
		// choose a move
		Real movechoice = RG.uniform()*weight_sum;
		Real sum=0.0;
		for(m=0;m< movers_.size(); m++){
			if(movechoice < sum) break;
			sum += weight_[m];
		}
		m--;
		//		tr.Trace << "choose move " << m+1 << " of " << nr_moves() << std::endl;
		// apply the chosen move
		movers_[m]->apply( pose );
		type( type() + movers_[m]->type());
	}

}

void CycleMover::apply( core::pose::Pose& pose )
{
	next_move_ %= movers_.size();
	movers_[ next_move_ ]->apply(pose);
	++next_move_;
}

}  // namespace moves

}  // namespace protocols
