// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file   protocols/moves/MoverFactory.hh
/// @brief
/// @author ashworth

#ifndef INCLUDED_protocols_moves_MoverFactory_HH
#define INCLUDED_protocols_moves_MoverFactory_HH

// Unit Headers
#include <protocols/moves/MoverFactory.fwd.hh>
#include <protocols/moves/Mover.fwd.hh>
#include <protocols/moves/DataMap.fwd.hh>
#include <protocols/filters/Filter.fwd.hh> // Filters_map (typedef)

#include <core/pose/Pose.fwd.hh>

// Utility Headers
#include <utility/pointer/ReferenceCount.hh>
#include <utility/Tag/Tag.fwd.hh>

// c++ headers
#include <map>

namespace protocols {
namespace moves {

class MoverFactory : public utility::pointer::ReferenceCount
{
public:
	typedef std::map< std::string, MoverOP > MoverMap;
	typedef utility::Tag::Tag Tag;
	typedef utility::Tag::TagPtr TagPtr;
	typedef core::pose::Pose Pose;

public:
	MoverFactory();
	virtual ~MoverFactory();

	///@brief add a Mover prototype, using its default type name as the map key
	void add_type( MoverOP );
	///@brief add a Mover prototype, using an arbitrary type name as the map key
	void add_type( std::string const &, MoverOP );
	///@brief return new Mover by key lookup in dock_design_filter_map_
	MoverOP newMover( std::string const & );
	///@brief return new Mover by Tag parsing
	MoverOP newMover(
		TagPtr const,
		DataMap &,
		protocols::filters::Filters_map const &,
		Movers_map const &,
		Pose const & );

private:
	MoverMap mover_prototype_map_;

};

} //namespace moves
} //namespace protocols

#endif
