// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file protocols/moves/TaskAwareMinMover.cc
/// @brief TaskAwareMinMover methods implemented
/// @author Steven Lewis


// Unit Headers
#include <protocols/moves/TaskAwareMinMover.hh>

// Package Headers

// Project Headers
#include <core/kinematics/MoveMap.hh>
#include <core/kinematics/util.hh>

#include <core/pose/Pose.hh>

#include <core/pack/task/TaskFactory.hh>
#include <core/pack/task/PackerTask.hh>

#include <protocols/moves/MinMover.hh>

// Utility Headers
#include <core/util/Tracer.hh>
#include <core/types.hh>
#include <utility/exit.hh>

// C++ Headers

using core::util::T;
using core::util::Error;
using core::util::Warning;


static core::util::Tracer TR( "protocols.moves.TaskAwareMinMover" );

namespace protocols {
namespace moves {

void TaskAwareMinMover::apply( core::pose::Pose & pose ){

  //clone the MinMover's MoveMap
  using core::kinematics::MoveMapOP;
  using core::kinematics::MoveMap;
  MoveMapOP mm = new MoveMap( *( minmover_->movemap() ) );

  //generate task
  using core::pack::task::PackerTaskOP;
  PackerTaskOP task( factory_->create_task_and_apply_taskoperations( pose ) );

  //modify movemap by task
  core::kinematics::modify_movemap_from_packertask( *mm, *task );

  //pass the modified map into the MinMover
  minmover_->movemap( mm );

	//now run MinMover
	minmover_->apply( pose );

}//apply

///@brief constructor with TaskFactory
TaskAwareMinMover::TaskAwareMinMover(
																		 protocols::moves::MinMoverOP minmover_in,
																		 core::pack::task::TaskFactoryCOP factory_in
																		 ) : Mover(), minmover_(minmover_in), factory_(factory_in)
{
	Mover::type( "TaskAwareMinMover" );
}

TaskAwareMinMover::~TaskAwareMinMover(){}

}//moves
}//protocols

