// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file
/// @brief
/// @author Liz Kellogg

/// Where is the ddGMover.fwd.hh include?

// Package headers
#include <protocols/moves/Mover.hh>

// Project headers
#include <core/pack/pack_rotamers.hh>
#include <core/pack/task/PackerTask.hh>
#include <core/pack/task/TaskFactory.hh>
#include <core/pose/Pose.hh>
#include <core/scoring/ScoreFunction.hh>
#include <core/scoring/ScoreFunctionFactory.hh>

// ObjexxFCL headers
#include <ObjexxFCL/FArray2D.hh>

#ifndef INCLUDED_protocols_moves_ddGMover_HH
#define INCLUDED_protocols_moves_ddGMover_HH

namespace protocols {
namespace moves {

	using namespace core;
	using namespace scoring;

	typedef std::vector<double> ddGs;

class ddGMover: public moves::Mover{
public:
	ddGMover();

	ddGMover(
					 core::scoring::ScoreFunctionOP s,
					 core::scoring::ScoreFunctionOP m,
					 utility::vector1<core::chemical::AA> res_to_mutate
					 );

	virtual ~ddGMover();

	//setter function
	void neighbor_cutoff(double cutoff);
	void restrict_to_nbrs(bool truefalse);
	void score_function( core::scoring::ScoreFunctionOP s);
	void set_minimization_score_function( core::scoring::ScoreFunctionOP s);
	void num_iterations(int num);
	void dump_pdbs(bool truefalse);
	void debug_output(bool truefalse);
	void is_interface_ddg(bool truefalse);
	void wt_score_components(ObjexxFCL::FArray2D<double> wsc);
	void wt_unbound_score_components(ObjexxFCL::FArray2D<double> wusc);
	void mutant_score_components(ObjexxFCL::FArray2D<double> msc);
	void residues_to_mutate(utility::vector1<core::chemical::AA> residues);
	void set_min_cst(bool truefalse);
	void set_mean(bool truefalse);
	void set_min(bool truefalse);

	//accessor function
	core::Real neighbor_cutoff();
	bool restrict_to_nbrs();
	core::scoring::ScoreFunctionOP score_function();
	core::scoring::ScoreFunctionOP minimization_score_function();
	int num_iterations();
	bool is_interface_ddg();
	ObjexxFCL::FArray2D<double> wt_score_components();
	ObjexxFCL::FArray2D<double> wt_unbound_score_components();
	ObjexxFCL::FArray2D<double> mutant_score_components();
	utility::vector1<core::chemical::AA> residues_to_mutate();

	utility::vector1<double> get_wt_min_score_components();
	utility::vector1<double> get_wt_averaged_score_components();
	utility::vector1<double> get_mutant_min_score_components();
	utility::vector1<double> get_mutant_averaged_score_components();
	utility::vector1<double> get_delta_energy_components();
	utility::vector1<std::string> get_scorefunction_header();
	std::string mutation_label(pose::Pose & pose);
	double get_wt_averaged_totals();
	double get_wt_min_totals();
	double get_mutant_averaged_totals();
	double get_mutant_min_totals();
	double ddG();
	virtual void apply(core::pose::Pose & pose);
	bool is_wt_calc_complete();
	bool is_mutant_calc_complete();
	bool is_properly_initialized(pose::Pose & pose);
	bool get_min_cst();
	bool use_mean();
	bool use_min();

private:
	bool mean_;
	bool min_;
	bool min_cst_;
	core::Real nbr_cutoff_;
	bool restrict_to_nbrhood_;
	bool interface_ddg_;
	core::scoring::ScoreFunctionOP scorefxn_;
	core::scoring::ScoreFunctionOP min_cst_sfxn_;
	utility::vector1<core::chemical::AA> residues_to_mutate_;
	int num_iterations_;
	bool dmp_pdb_;
	bool dbg_output_;
	ObjexxFCL::FArray2D<double> wt_components_;
	ObjexxFCL::FArray2D<double> wt_unbound_components_; //ek interface ddg capabilities;
	ObjexxFCL::FArray2D<double> mutant_components_;
	ObjexxFCL::FArray2D<double> mutant_unbound_components_; //ek interface ddg capabilities;
	utility::vector1<pose::Pose> natives_;
	utility::vector1<pose::Pose> mutants_;

	bool is_complete(ObjexxFCL::FArray2D<double> to_check);

	double sum(ddGs &scores_to_sum);
	double average( utility::vector1<double> &scores_to_average);
	int store_energies(ObjexxFCL::FArray2D< double > &two_d_e_arrays,
										 scoring::ScoreFunction &s,
										 pose::Pose &p, int next_index , int size_to_expect);
	int average_score_components(ObjexxFCL::FArray2D< double > &scores_to_average,
															 utility::vector1<double> &averaged_scores );
	//int which_iteration(ObjexxFCL::FArray2D<double> scores);//locates uninitialized values
	//and returns the iteration to continue on
	//above not used/???

	void calculate_interface_unbound_energy(pose::Pose & p,ScoreFunctionOP s,core::pack::task::PackerTaskOP pt);

	void setup_constraints(pose::Pose & pose, ScoreFunctionOP sfxn, float const cst_tol);

	void minimize_with_constraints(pose::Pose & pose,ScoreFunctionOP s);

};
} //moves
} //protocols
#endif

