// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file
/// @brief
/// @author


#ifndef INCLUDED_protocols_moves_mc_convergence_checks_Pool_ConvergenceCheck_HH
#define INCLUDED_protocols_moves_mc_convergence_checks_Pool_ConvergenceCheck_HH


// type headers
#include <core/types.hh>

// unit headers
#include <protocols/moves/mc_convergence_checks/ConvergenceCheck.hh>
#include <protocols/moves/MonteCarlo.fwd.hh>
#include <protocols/toolbox/DecoySetEvaluation.hh>
#include <protocols/evaluation/PoseEvaluator.hh>

// package headers
#include <core/pose/Pose.fwd.hh>
#include <core/scoring/ScoreFunction.fwd.hh>

// utility headers
#include <utility/pointer/ReferenceCount.hh>
// #include "utility/basic_sys_util.h"

// C++ headers
#include <map>
#include <string>

// Forward declarations

namespace protocols {
namespace moves {
namespace mc_convergence_checks {

class EXCN_Pool_Converged : public EXCN_Converged {};

class Pool_RMSD;

typedef utility::pointer::owning_ptr< Pool_RMSD > Pool_RMSD_OP;


class Pool_RMSD : public utility::pointer::ReferenceCount {
	typedef utility::vector1< std::string > Tags;
public:
	//c'stor supply file with structures and threshold (Angstroem RMSD)
	Pool_RMSD( std::string silent_file )
	{ fill_pool( silent_file); };

	void evaluate( core::pose::Pose const&, std::string& best_decoy, core::Real& best_rmsd ) const;
private:

	void fill_pool( std::string const& silentfile );

	toolbox::DecoySetEvaluation pool_;

	Tags tags_;
};

class Pool_ConvergenceCheck : public ConvergenceCheck {
public:
	Pool_ConvergenceCheck( Pool_RMSD_OP rmsd_pool_in, core::Real threshold )
		: threshold_( threshold ),
			rmsd_pool_( rmsd_pool_in ) {};

	//throws EXCN_Pool_Converged if lowest_score pose is < threshold away from any pool structure
	virtual bool operator() ( const core::pose::Pose&, moves::MonteCarlo const& mc, bool /*reject*/ );

private:
	core::Real threshold_;
	Pool_RMSD_OP rmsd_pool_;
};

class Pool_Evaluator : public evaluation::PoseEvaluator {
public:
	Pool_Evaluator( Pool_RMSD_OP rmsd_pool_in ) : rmsd_pool_( rmsd_pool_in ) {};
	/// from PoseEvaluator interface:

	///@brief evaluate pose and store values in Silent_Struct
	virtual void apply( core::pose::Pose&, std::string tag, core::io::silent::SilentStruct &pss) const;

	//	void apply( core::pose::Pose&, std::string tag, core::io::silent::SilentStruct &pss) const;
	virtual core::Size size() const { return 2; };
	virtual std::string name( core::Size i ) const {
		if ( i == 1 ) return "pool_converged_tag";
		if ( i == 2 ) return "pool_converged_rmsd";
		return "NO_TAG";
	}
private:
	Pool_RMSD_OP rmsd_pool_;
};

} // mc_convergence_check
} // moves
} // rosetta

#endif
