// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// This file is part of the Rosetta software suite and is made available under license.
// The Rosetta software is developed by the contributing members of the Rosetta Commons consortium.
// (C) 199x-2009 Rosetta Commons participating institutions and developers.
// For more information, see http://www.rosettacommons.org/.

/// @file
/// @brief
/// @author Ingemar Andre


#ifndef INCLUDED_protocols_moves_symmetry_SetupForSymmetryMover_HH

#define INCLUDED_protocols_moves_symmetry_SetupForSymmetryMover_HH

// Unit headers
#include <protocols/moves/symmetry/SetupForSymmetryMover.fwd.hh>
#include <protocols/moves/Mover.hh>
#include <core/pose/Pose.fwd.hh>

// Utility Headers

namespace protocols {
namespace moves {
namespace symmetry {
///////////////////////////////////////////////////////////////////////////////
class SetupForSymmetryMover : public Mover
{

public:

	// default constructor
	SetupForSymmetryMover();

	SetupForSymmetryMover( std::string const & );

	~SetupForSymmetryMover();

	void apply( core::pose::Pose & pose );

};

} // symmetry
} // moves
} // rosetta
#endif
