// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// This file is part of the Rosetta software suite and is made available under license.
// The Rosetta software is developed by the contributing members of the Rosetta Commons consortium.
// (C) 199x-2009 Rosetta Commons participating institutions and developers.
// For more information, see http://www.rosettacommons.org/.

/// @file
/// @brief
/// @author Ingemar Andre


#ifndef INCLUDED_protocols_moves_symmetry_SymFoldandDockRbTrialMover_HH

#define INCLUDED_protocols_moves_symmetry_SymFoldandDockRbTrialMover_HH

// Unit headers
#include <protocols/moves/symmetry/SymFoldandDockRbTrialMover.fwd.hh>
#include <protocols/moves/Mover.hh>
#include <core/scoring/ScoreFunction.fwd.hh>
#include <protocols/moves/MonteCarlo.fwd.hh>
#include <core/pose/Pose.fwd.hh>

// Utility Headers

namespace protocols {
namespace moves {
namespace symmetry {
///////////////////////////////////////////////////////////////////////////////
class SymFoldandDockRbTrialMover : public Mover
{

public:

	// default constructor

	SymFoldandDockRbTrialMover();

	SymFoldandDockRbTrialMover( core::scoring::ScoreFunctionCOP scorefxn );

	SymFoldandDockRbTrialMover(
		core::scoring::ScoreFunctionCOP scorefxn,
		bool smooth_move,
		core::Real rot_mag,
		core::Real trans_mag,
		core::Size rigid_body_frequency
 );

	~SymFoldandDockRbTrialMover(){}

	void apply( core::pose::Pose & pose );

private:
	core::scoring::ScoreFunctionCOP scorefxn_;
	//protocols::moves::MonteCarloOP monteCarlo_;
	bool smooth_move_;
	core::Real rot_mag_;
	core::Real trans_mag_;
	core::Size rigid_body_frequency_;
};

} // symmetry
} // moves
} // rosetta
#endif
