// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// This file is part of the Rosetta software suite and is made available under license.
// The Rosetta software is developed by the contributing members of the Rosetta Commons consortium.
// (C) 199x-2009 Rosetta Commons participating institutions and developers.
// For more information, see http://www.rosettacommons.org/.

/// @file MinMover.cc
/// @brief
/// @author Ingemar Andre

// Unit headers
#include <protocols/moves/symmetry/SymFoldandDockSlideTrialMover.hh>
#include <protocols/moves/symmetry/SetupForSymmetryMover.hh>
#include <protocols/symmetric_docking/SymDockingInitialPerturbation.hh>

// Package headers
#include <core/conformation/symmetry/SymmetricConformation.hh>
#include <core/conformation/symmetry/util.hh>

// options
#include <core/options/option.hh>
#include <core/options/keys/fold_and_dock.OptionKeys.gen.hh>

// ObjexxFCL Headers

// C++ Headers

// Utility Headers
#include <core/util/Tracer.hh>

namespace protocols {
namespace moves {
namespace symmetry {

static core::util::Tracer TR("protocols.moves.symmetry.SymFoldandDockSlideTrialMover");

SymFoldandDockSlideTrialMover::SymFoldandDockSlideTrialMover()
	: Mover("SymFoldandDockSlideTrialMover") {}

SymFoldandDockSlideTrialMover::~SymFoldandDockSlideTrialMover(){}

void
SymFoldandDockSlideTrialMover::apply( core::pose::Pose & pose )
{
	moves::symmetry::SetupForSymmetryMover setup;
	setup.apply( pose );

	using namespace core::conformation::symmetry;
	using namespace core::options;

  assert( is_symmetric( pose ));
  SymmetricConformation & symm_conf (
        dynamic_cast<SymmetricConformation & > ( pose.conformation()) );

  std::map< Size, SymDof > dofs ( symm_conf.Symmetry_Info().get_dofs() );

	protocols::symmetric_docking::SymDockingSlideIntoContact slide( dofs );

	if ( option[ OptionKeys::fold_and_dock::rotate_anchor_to_x ].user() ) {
		rotate_anchor_to_x_axis( pose );
	}
	slide.apply( pose );
}

} // symmetry
} // moves
} // protocols
